/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.internal.db;

import android.arch.lifecycle.LiveData;
import android.arch.persistence.room.Dao;
import android.arch.persistence.room.Insert;
import android.arch.persistence.room.Query;
import com.flybits.internal.db.models.CachingEntry;
import java.util.List;

@Dao
public interface CachingEntryDAO {
    @Query(value="SELECT contentID FROM cachingentry WHERE cachingkey = :key order by sequence ASC")
    public List<String> getIdsByCachingKey(String var1);

    @Query(value="SELECT contentId FROM ( SELECT contentID, sequence, cachingkey FROM cachingentry GROUP BY contentID HAVING COUNT(contentID) = 1 ) WHERE cachingkey = :key ORDER BY sequence ASC")
    public List<String> getUniqueIdsByCachingKey(String var1);

    @Query(value="SELECT * FROM cachingentry WHERE cachingkey = :key order by sequence ASC")
    public List<CachingEntry> getByKey(String var1);

    @Query(value="SELECT * FROM ( SELECT * FROM cachingentry GROUP BY contentID HAVING COUNT(contentID) = 1 ) WHERE cachingkey = :key ORDER BY sequence ASC")
    public List<CachingEntry> getUniqueByKey(String var1);

    @Insert(onConflict=1)
    public void insert(CachingEntry var1);

    @Insert(onConflict=1)
    public void insert(List<CachingEntry> var1);

    @Query(value="Delete from cachingentry")
    public void clear();

    @Query(value="Delete from cachingentry WHERE cachingkey = :key")
    public void deleteAllByCachingKey(String var1);

    @Query(value="Delete from cachingentry WHERE cachingkey = :key AND contentID = :value")
    public void deleteByCachingKeyAndValue(String var1, String var2);

    @Query(value="SELECT * FROM cachingentry WHERE cachingkey = :key order by sequence ASC")
    public LiveData<List<CachingEntry>> getLive(String var1);
}

