package com.flybits.commons.library.exceptions

/**
 * The [InvalidParameterException] is thrown whenever a parameter is provided with an invalid value.
 * One simple example can be a "url" parameter contains a value that is not a valid URL.
 *
 * @param parameterName The parameter that is invalid
 * @param reason The reason that the value is invalid
 */
class InvalidParameterException(parameterName : String, reason : String)
    : FlybitsException("$reason is invalid for $parameterName. Please read the documentation for accepted values.")
