package com.flybits.commons.library.exceptions;

/**
 *  The {@code ServiceNotSetException} class is thrown whenever the application has not added a
 *  service to the {@code AndroidManifest.xml} file that is needed to continue.
 *
 *  @since 1.0.0
 */
public class ServiceNotSetException extends RuntimeException {

    /**
     * Constructs an empty {@code ServiceNotSetException}.
     */
    public ServiceNotSetException(){}

    /**
     * Constructs a new {@code ServiceNotSetException} with a specified message indicating why the
     * exception was thrown.
     *
     * @param message the detail message for this exception.
     */
    public ServiceNotSetException(String message) {
        super(message);
    }

    /**
     * Constructs a new {@code ServiceNotSetException} with the cause of the exception.
     *
     * @param throwable the cause of this exception.
     */
    public ServiceNotSetException(Throwable throwable){
        super(throwable);
    }

    /**
     * Constructs a new {@code ServiceNotSetException} with the specified detail message and the
     * specified cause.
     *
     * @param detailMessage the detail message for this exception.
     * @param throwable the cause of this exception.
     */
    public ServiceNotSetException(String detailMessage, Throwable throwable){
        super(detailMessage, throwable);
    }
}