/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.models;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import com.flybits.commons.library.SharedElementsFactory;
import com.flybits.commons.library.api.FlyAway;
import com.flybits.commons.library.api.results.BasicResult;
import com.flybits.commons.library.api.results.ObjectResult;
import com.flybits.commons.library.api.results.callbacks.BasicResultCallback;
import com.flybits.commons.library.api.results.callbacks.ObjectResultCallback;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.http.HttpDefaultClass;
import com.flybits.commons.library.http.RequestStatus;
import com.flybits.commons.library.models.JsonParser;
import com.flybits.commons.library.models.Jwt;
import com.flybits.commons.library.models.internal.Result;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONException;
import org.json.JSONObject;

public class Project {
    static final String URL_SETTINGS = "/sso/settings/configs";
    static final String PROJECT_ENDPOINT = "/sso/auth/project";
    static final String TYPE_PROJECT_SETTINGS = "project-settings";
    private String creatorId;
    private String id;
    private boolean isActive;
    private String name;
    private String subdomain;
    private String tierId;

    public Project(String id, String creatorId, String name, String subdomain, String tierId, boolean isActive) {
        this.creatorId = creatorId;
        this.id = id;
        this.isActive = isActive;
        this.name = name;
        this.subdomain = subdomain;
        this.tierId = tierId;
    }

    public String getId() {
        return this.id;
    }

    public String getCreatorId() {
        return this.creatorId;
    }

    public String getName() {
        return this.name;
    }

    public String getSubdomain() {
        return this.subdomain;
    }

    public String getTierId() {
        return this.tierId;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public static BasicResult bindProject(final Context context, final String projectId, BasicResultCallback callback, @NonNull Handler handler) {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        final BasicResult request = new BasicResult(callback, handler, executorService);
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    String currentJwtToken = SharedElementsFactory.INSTANCE.get(context).getSavedJWTToken();
                    Jwt currentJwt = Jwt.decodeJWTToken(currentJwtToken);
                    if (currentJwt.isProjectBound()) {
                        throw new FlybitsException("There is already a project bound, the client must logout first.");
                    }
                    HashMap<String, String> headers = new HashMap<String, String>();
                    String url = String.format("%s?projectId=%s", Project.PROJECT_ENDPOINT, projectId);
                    try {
                        Result bound = new HttpDefaultClass.Builder(context, true, url).addHeaders(headers).get().getResponse();
                        request.setResult(bound);
                    }
                    catch (Exception e) {
                        throw new FlybitsException("Error Connecting to Flybits Server: FlybitsManager.bindProject");
                    }
                }
                catch (FlybitsException e) {
                    request.setFailed(e);
                }
            }
        });
        return request;
    }

    public static BasicResult bindProject(Context context, String projectId, BasicResultCallback callback) {
        return Project.bindProject(context, projectId, callback, new Handler(Looper.getMainLooper()));
    }

    public static <T extends JsonParser> ObjectResult<T> getProjectSettings(Context context, Class<T> clazz, ObjectResultCallback<T> callback, Handler handler) {
        return Project.getSettings(TYPE_PROJECT_SETTINGS, context, clazz, callback, handler);
    }

    public static <T extends JsonParser> ObjectResult<T> getProjectSettings(Context context, Class<T> clazz, ObjectResultCallback<T> callback) {
        return Project.getSettings(TYPE_PROJECT_SETTINGS, context, clazz, callback, new Handler(Looper.getMainLooper()));
    }

    public static <T extends JsonParser> ObjectResult<T> getSettings(@NonNull String type, Context context, Class<T> clazz, ObjectResultCallback<T> callback) {
        return Project.getSettings(type, context, clazz, callback, new Handler(Looper.getMainLooper()));
    }

    public static <T extends JsonParser> ObjectResult<T> getSettings(final @NonNull String type, final Context context, final Class<T> clazz, ObjectResultCallback<T> callback, @NonNull Handler handler) {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        final ObjectResult<T> request = new ObjectResult<T>(callback, handler, executorService);
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    String url = String.format("%s/%s", Project.URL_SETTINGS, type);
                    Result getSettings = FlyAway.get(context, url, null, "Project.GetSettings", null);
                    if (getSettings.getStatus() == RequestStatus.COMPLETED) {
                        String response = getSettings.getResultAsString();
                        JSONObject object = new JSONObject(response);
                        if (!object.isNull("settings")) {
                            JSONObject settingsObject = object.getJSONObject("settings");
                            JsonParser newInstance = (JsonParser)clazz.newInstance();
                            newInstance.fromJson(settingsObject.toString());
                            request.setSuccess(newInstance);
                        } else {
                            request.setFailed(new FlybitsException("Unable to parse the JSON based on the defined fromJSON(String) method"));
                        }
                    } else if (getSettings.getStatus() == RequestStatus.NOT_FOUND) {
                        JsonParser newInstance = (JsonParser)clazz.newInstance();
                        request.setSuccess(newInstance);
                    } else {
                        request.setResult(getSettings);
                    }
                }
                catch (FlybitsException e) {
                    request.setFailed(e);
                }
                catch (ClassCastException | IllegalAccessException | InstantiationException | JSONException e) {
                    FlybitsException exception = new FlybitsException(e);
                    request.setFailed(exception);
                }
            }
        });
        return request;
    }
}

