package com.flybits.internal.db;

import androidx.lifecycle.LiveData;
import androidx.room.Dao;
import androidx.room.Insert;
import androidx.room.OnConflictStrategy;
import androidx.room.Query;
import androidx.room.Update;

import com.flybits.commons.library.models.User;

@Dao
public interface UserDAO {

    @Query("Select * from user LIMIT 1")
    LiveData<User> get();

    @Query("Select * from user LIMIT 1")
    User getSingle();

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    void insert(User plugins);

    @Query("Delete from user")
    void delete();

    @Update
    void update(User plugin);
}
