package com.flybits.commons.library.analytics

import android.content.Context
import androidx.work.Worker
import androidx.work.WorkerParameters
import com.flybits.commons.library.exceptions.FlybitsException
import com.flybits.commons.library.logging.Logger

class AnalyticsWorker(context: Context, workerParameters: WorkerParameters): Worker(context, workerParameters) {

    companion object {
        fun doWork(applicationContext: Context): Result{
            return try{
                Analytics(applicationContext).flush()
                Result.success()
            }catch(e: FlybitsException){
                Logger.exception("AnalyticsWorker.doWork()", e)
                Result.failure()
            }
        }
    }

    override fun doWork(): Result {
        return doWork(applicationContext)
    }
}