/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.api;

import android.content.Context;
import android.support.annotation.NonNull;
import com.flybits.commons.library.api.OptInStateObservable;
import com.flybits.commons.library.deserializations.IDeserializer;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.http.HttpDefaultClass;
import com.flybits.commons.library.http.RequestStatus;
import com.flybits.commons.library.logging.Logger;
import com.flybits.commons.library.models.internal.PagedResponse;
import com.flybits.commons.library.models.internal.QueryParameters;
import com.flybits.commons.library.models.internal.Result;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.RequestBody;

public class FlyAway {
    public static <T> Result<PagedResponse<T>> get(@NonNull Context mContext, @NonNull String urlEndpoint, QueryParameters params, @NonNull IDeserializer deserializer, @NonNull String uniqueIdentifier) throws FlybitsException {
        return FlyAway.get(mContext, urlEndpoint, null, params, deserializer, uniqueIdentifier);
    }

    public static <T> Result<PagedResponse<T>> get(@NonNull Context context, @NonNull String urlEndpoint, HashMap<String, String> headers, QueryParameters params, @NonNull IDeserializer deserializer, @NonNull String uniqueIdentifier) throws FlybitsException {
        if (context == null) {
            throw new FlybitsException("The Context parameter must not be null");
        }
        if (urlEndpoint == null || urlEndpoint.length() == 0) {
            throw new FlybitsException("The urlEndpoint parameter must be set");
        }
        if (deserializer == null) {
            throw new FlybitsException("The IDeserializer parameter must not be null");
        }
        if (uniqueIdentifier == null) {
            throw new FlybitsException("The uniqueIdentifier parameter must not be null");
        }
        try {
            Result result = new HttpDefaultClass.Builder(context, true, urlEndpoint, params).addHeaders(headers).get().getResponse();
            if (result.getStatus() == RequestStatus.COMPLETED) {
                PagedResponse response = (PagedResponse)deserializer.fromJson(result.getResultAsString());
                if (response != null) {
                    result.setResponse(response);
                } else {
                    result = new Result(new FlybitsException("Parsing Error"), result.getResultAsString());
                }
            } else if (result.getStatus() == RequestStatus.OPTED_OUT) {
                OptInStateObservable.INSTANCE.broadcastOptedInStateChange(false);
            }
            return result;
        }
        catch (Exception e) {
            Logger.exception(uniqueIdentifier, e);
            if (e instanceof ClassCastException) {
                throw new FlybitsException("Invalid Deserializer for this request: " + deserializer.getClass());
            }
            throw new FlybitsException("Error Connecting to Flybits Server: " + uniqueIdentifier);
        }
    }

    public static <T> Result<ArrayList<T>> get(@NonNull Context context, @NonNull String urlEndpoint, HashMap<String, String> headers, Map<String, String> queryParameters, @NonNull IDeserializer deserializer, @NonNull String uniqueIdentifier) throws FlybitsException {
        if (context == null) {
            throw new FlybitsException("The Context parameter must not be null");
        }
        if (urlEndpoint == null || urlEndpoint.length() == 0) {
            throw new FlybitsException("The urlEndpoint parameter must be set");
        }
        if (deserializer == null) {
            throw new FlybitsException("The IDeserializer parameter must not be null");
        }
        if (uniqueIdentifier == null) {
            throw new FlybitsException("The uniqueIdentifier parameter must not be null");
        }
        try {
            Result<ArrayList<ArrayList<Object>>> result = new HttpDefaultClass.Builder(context, true, urlEndpoint, queryParameters).addHeaders(headers).get().getResponse();
            if (result.getStatus() == RequestStatus.COMPLETED) {
                ArrayList response = (ArrayList)deserializer.fromJson(result.getResultAsString());
                if (response != null) {
                    result.setResponse(response);
                } else {
                    result = new Result(new FlybitsException("Parsing Error"), result.getResultAsString());
                }
            } else if (result.getStatus() == RequestStatus.OPTED_OUT) {
                OptInStateObservable.INSTANCE.broadcastOptedInStateChange(false);
            }
            return result;
        }
        catch (Exception e) {
            Logger.exception(uniqueIdentifier, e);
            if (e instanceof ClassCastException) {
                throw new FlybitsException("Invalid Deserializer for this request: " + deserializer.getClass());
            }
            throw new FlybitsException("Error Connecting to Flybits Server: " + uniqueIdentifier);
        }
    }

    public static <T> Result<T> get(@NonNull Context context, @NonNull String urlEndpoint, IDeserializer deserializer, @NonNull String uniqueIdentifier, Class<T> type) throws FlybitsException {
        return FlyAway.get(context, urlEndpoint, null, deserializer, uniqueIdentifier, type);
    }

    public static <T> Result<T> get(@NonNull Context context, @NonNull String urlEndpoint, HashMap<String, String> headers, IDeserializer deserializer, @NonNull String uniqueIdentifier, Class<T> type) throws FlybitsException {
        if (context == null) {
            throw new FlybitsException("The Context parameter must not be null");
        }
        if (urlEndpoint == null || urlEndpoint.length() == 0) {
            throw new FlybitsException("The urlEndpoint parameter must be set");
        }
        if (uniqueIdentifier == null) {
            throw new FlybitsException("The uniqueIdentifier parameter must not be null");
        }
        if (deserializer == null && type != null || deserializer != null && type == null) {
            throw new FlybitsException("If either the deserializer or the type parameter are null then the other must be null as well");
        }
        try {
            Result<T> result = new HttpDefaultClass.Builder(context, true, urlEndpoint).addHeaders(headers).get().getResponse();
            if (result.getStatus() == RequestStatus.COMPLETED && deserializer != null) {
                T response = type.cast(deserializer.fromJson(result.getResultAsString()));
                if (response != null) {
                    result.setResponse(response);
                } else {
                    result = new Result(new FlybitsException("Parsing Error"), result.getResultAsString());
                }
            } else if (result.getStatus() == RequestStatus.OPTED_OUT) {
                OptInStateObservable.INSTANCE.broadcastOptedInStateChange(false);
            }
            return result;
        }
        catch (Exception e) {
            if (e instanceof ClassCastException) {
                throw new FlybitsException("Invalid Deserializer for this request: " + deserializer.getClass());
            }
            throw new FlybitsException("Error Connecting to Flybits Server: " + uniqueIdentifier);
        }
    }

    public static <T> Result<T> post(@NonNull Context context, @NonNull String urlEndpoint, String json, IDeserializer deserializer, @NonNull String uniqueIdentifier, Class<T> type) throws FlybitsException {
        if (json == null) {
            json = "";
        }
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)json);
        return FlyAway.post(context, urlEndpoint, null, requestBody, deserializer, uniqueIdentifier, type);
    }

    public static <T> Result<T> post(@NonNull Context context, @NonNull String urlEndpoint, RequestBody requestBody, IDeserializer deserializer, @NonNull String uniqueIdentifier, Class<T> type) throws FlybitsException {
        if (requestBody == null) {
            requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)"");
        }
        return FlyAway.post(context, urlEndpoint, null, requestBody, deserializer, uniqueIdentifier, type);
    }

    public static <T> Result<T> post(@NonNull Context context, @NonNull String urlEndpoint, HashMap<String, String> headers, RequestBody requestBody, IDeserializer deserializer, @NonNull String uniqueIdentifier, Class<T> type) throws FlybitsException {
        if (context == null) {
            throw new FlybitsException("The Context parameter must not be null");
        }
        if (urlEndpoint == null || urlEndpoint.length() == 0) {
            throw new FlybitsException("The urlEndpoint parameter must be set");
        }
        if (uniqueIdentifier == null) {
            throw new FlybitsException("The uniqueIdentifier parameter must not be null");
        }
        if (deserializer == null && type != null || deserializer != null && type == null) {
            throw new FlybitsException("If either the deserializer or the type parameter are null then the other must be null as well");
        }
        try {
            Result<T> result = new HttpDefaultClass.Builder(context, true, urlEndpoint).addHeaders(headers).post(requestBody).getResponse();
            if (result.getStatus() == RequestStatus.COMPLETED && type != null) {
                T response = type.cast(deserializer.fromJson(result.getResultAsString()));
                if (response != null) {
                    result.setResponse(response);
                } else {
                    result = new Result(new FlybitsException("Parsing Error"), result.getResultAsString());
                }
            } else if (result.getStatus() == RequestStatus.OPTED_OUT) {
                OptInStateObservable.INSTANCE.broadcastOptedInStateChange(false);
            }
            return result;
        }
        catch (Exception e) {
            if (e instanceof ClassCastException) {
                throw new FlybitsException("Invalid Deserializer for this request: " + deserializer.getClass());
            }
            throw new FlybitsException("Error Connecting to Flybits Server: " + uniqueIdentifier);
        }
    }

    public static <T> Result<T> put(@NonNull Context context, @NonNull String urlEndpoint, @NonNull RequestBody requestBody, IDeserializer deserializer, @NonNull String uniqueIdentifier, Class<T> type) throws FlybitsException {
        return FlyAway.put(context, urlEndpoint, null, requestBody, deserializer, uniqueIdentifier, type);
    }

    public static <T> Result<T> put(@NonNull Context context, @NonNull String urlEndpoint, @NonNull String json, IDeserializer deserializer, @NonNull String uniqueIdentifier, Class<T> type) throws FlybitsException {
        RequestBody requestBody = json == null ? null : RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)json);
        return FlyAway.put(context, urlEndpoint, null, requestBody, deserializer, uniqueIdentifier, type);
    }

    public static <T> Result<T> put(@NonNull Context context, @NonNull String urlEndpoint, HashMap<String, String> headers, @NonNull RequestBody requestBody, IDeserializer deserializer, @NonNull String uniqueIdentifier, Class<T> type) throws FlybitsException {
        if (context == null) {
            throw new FlybitsException("The Context parameter must not be null");
        }
        if (urlEndpoint == null || urlEndpoint.length() == 0) {
            throw new FlybitsException("The urlEndpoint parameter must be set");
        }
        if (uniqueIdentifier == null) {
            throw new FlybitsException("The uniqueIdentifier parameter must not be null");
        }
        if (requestBody == null) {
            throw new FlybitsException("The Request body parameter must not be null");
        }
        if (deserializer == null && type != null || deserializer != null && type == null) {
            throw new FlybitsException("If either the deserializer or the type parameter are null then the other must be null as well");
        }
        try {
            Result<T> result = new HttpDefaultClass.Builder(context, true, urlEndpoint).addHeaders(headers).put(requestBody).getResponse();
            if (result.getStatus() == RequestStatus.COMPLETED && type != null) {
                T response = type.cast(deserializer.fromJson(result.getResultAsString()));
                if (response != null) {
                    result.setResponse(response);
                } else {
                    result = new Result(new FlybitsException("Parsing Error"), result.getResultAsString());
                }
            } else if (result.getStatus() == RequestStatus.OPTED_OUT) {
                OptInStateObservable.INSTANCE.broadcastOptedInStateChange(false);
            }
            return result;
        }
        catch (Exception e) {
            if (e instanceof ClassCastException) {
                throw new FlybitsException("Invalid Deserializer for this request: " + deserializer.getClass());
            }
            throw new FlybitsException("Error Connecting to Flybits Server: " + uniqueIdentifier);
        }
    }

    public static Result delete(@NonNull Context context, @NonNull String urlEndpoint, @NonNull String uniqueIdentifier, String id) throws FlybitsException {
        return FlyAway.delete(context, urlEndpoint, null, uniqueIdentifier, id);
    }

    public static Result delete(@NonNull Context context, @NonNull String urlEndpoint, HashMap<String, String> headers, @NonNull String uniqueIdentifier, String id) throws FlybitsException {
        if (context == null) {
            throw new FlybitsException("The Context parameter must not be null");
        }
        if (urlEndpoint == null || urlEndpoint.length() == 0) {
            throw new FlybitsException("The urlEndpoint parameter must be set");
        }
        if (uniqueIdentifier == null) {
            throw new FlybitsException("The uniqueIdentifier parameter must not be null");
        }
        if (id != null) {
            urlEndpoint = urlEndpoint + "/" + id;
        }
        try {
            Result result = new HttpDefaultClass.Builder(context, true, urlEndpoint).addHeaders(headers).delete().getResponse();
            if (result.getStatus() == RequestStatus.OPTED_OUT) {
                OptInStateObservable.INSTANCE.broadcastOptedInStateChange(false);
            }
            return result;
        }
        catch (IOException | NullPointerException e) {
            Logger.exception(uniqueIdentifier, e);
            throw new FlybitsException("Error Connecting to Flybits Server: " + uniqueIdentifier);
        }
    }
}

