/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.models;

import android.util.Base64;
import org.json.JSONException;
import org.json.JSONObject;

public class Jwt {
    private long exp;
    private long nbf;
    private String userID;
    private String deviceID;
    private String tenantID;
    private boolean isServiceAccount;

    private Jwt(String userID, String deviceID, String tenantID, long exp, long nbf, boolean isServiceAccount) {
        this.userID = userID;
        this.deviceID = deviceID;
        this.tenantID = tenantID;
        this.exp = exp;
        this.nbf = nbf;
        this.isServiceAccount = isServiceAccount;
    }

    public static Jwt decodeJWTToken(String token) {
        if (!token.contains(".")) {
            throw new IllegalArgumentException("Not a valid JWT token.");
        }
        String[] split = token.split("\\.");
        if (split.length < 2) {
            throw new IllegalArgumentException("JWT token missing payload.");
        }
        byte[] data = Base64.decode((String)split[1], (int)0);
        String decoded = new String(data);
        try {
            JSONObject object = new JSONObject(decoded);
            String userId = object.getString("userID");
            String deviceId = object.getString("deviceID");
            String projectId = object.getString("tenantID");
            long expires = object.getLong("exp");
            long nbf = object.getLong("nbf");
            return new Jwt(userId, deviceId, projectId, expires, nbf, false);
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("JWT token payload invalid.");
        }
    }

    public String getUserID() {
        return this.userID;
    }

    public String getDeviceID() {
        return this.deviceID;
    }

    public String getProjectID() {
        return this.tenantID;
    }

    public boolean isProjectBound() {
        return !this.tenantID.equals("00000000-0000-0000-0000-000000000000");
    }

    public long getExpiry() {
        return this.exp;
    }
}

