/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.utils.jbool_expressions;

import com.flybits.commons.library.utils.jbool_expressions.And;
import com.flybits.commons.library.utils.jbool_expressions.Expression;
import com.flybits.commons.library.utils.jbool_expressions.Literal;
import com.flybits.commons.library.utils.jbool_expressions.Not;
import com.flybits.commons.library.utils.jbool_expressions.Rule;
import java.util.ArrayList;

class SimplifyAnd<K>
extends Rule<And<K>, K> {
    SimplifyAnd() {
    }

    @Override
    public Expression<K> applyInternal(And<K> input) {
        for (Expression expr : input.expressions) {
            if (expr instanceof Literal) {
                Literal l = (Literal)expr;
                if (l.getValue()) {
                    return this.copyWithoutTrue(input);
                }
                return Literal.getFalse();
            }
            if (!(expr instanceof Not)) continue;
            Expression notChild = ((Not)expr).getE();
            for (Expression child : input.expressions) {
                if (!child.equals(notChild)) continue;
                return Literal.getFalse();
            }
        }
        return input;
    }

    private Expression<K> copyWithoutTrue(And<K> input) {
        ArrayList<Expression> copy = new ArrayList<Expression>();
        for (Expression expr : input.expressions) {
            Literal l;
            if (expr instanceof Literal && (l = (Literal)expr).getValue()) continue;
            copy.add(expr);
        }
        if (copy.isEmpty()) {
            return Literal.getTrue();
        }
        return And.of(copy);
    }

    @Override
    protected boolean isApply(Expression<K> input) {
        return input instanceof And;
    }
}

