package com.flybits.commons.library.api.results.callbacks;

import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.models.internal.Pagination;

import java.util.ArrayList;

/**
 * Callback used to indicate whether or not the network request for a list response was successful
 * or not.
 *
 * @param <T> The item that is expected to be returned as a list for this query.
 */
public interface PagedResultCallback<T> {
    /**
     * Indicates that the network request was successful.
     *
     * @param items The item that is expected to be returned as a list for this query.
     * @param pagination The pagination object that indicates the maximum number of items can be
     *                   queried as par of this request.
     */
    void onSuccess(ArrayList<T> items, Pagination pagination);

    /**
     * Indicates that the network request was not successful due to an error thrown by the server.
     *
     * @param exception The {@link FlybitsException} that indicates the exception that was
     *                  thrown.
     */
    void onException(FlybitsException exception);

    /**
     * Indicates that all the items in the list have been loaded
     */
    void onLoadedAllItems();
}
