package com.flybits.commons.library

import android.content.Context
import android.content.SharedPreferences
import com.flybits.internal.db.UserDAO

/**
 * Instances of this class will not encrypt any information stored within it.
 *
 * @param sharedPreferences [SharedPreferences] to be used for storing keys and values.
 *
 * @param userDAO [UserDAO] for retrieving and storing user data.
 */
class UnsecuredSharedElements internal constructor(sharedPreferences: SharedPreferences, userDAO: UserDAO): SharedElements(sharedPreferences, userDAO) {
    override fun performMigration(context: Context, args: Map<String, String>): Int {
        return 0
    }
}