/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library;

import android.content.Context;
import android.content.SharedPreferences;
import com.flybits.commons.library.logging.Logger;
import com.flybits.commons.library.models.User;
import com.flybits.commons.library.utils.Utilities;
import com.flybits.internal.db.CommonsDatabase;
import com.flybits.internal.db.UserDAO;
import devliving.online.securedpreferencestore.DefaultRecoveryHandler;
import devliving.online.securedpreferencestore.RecoveryHandler;
import devliving.online.securedpreferencestore.SecuredPreferenceStore;
import java.util.ArrayList;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0016\u0018\u0000 #2\u00020\u0001:\u0001#B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nJ\u0006\u0010\f\u001a\u00020\nJ\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000eJ\u000e\u0010\u000f\u001a\n \u000b*\u0004\u0018\u00010\n0\nJ\u000e\u0010\u0010\u001a\n \u000b*\u0004\u0018\u00010\n0\nJ\u000e\u0010\u0011\u001a\n \u000b*\u0004\u0018\u00010\n0\nJ \u0010\u0012\u001a\n \u000b*\u0004\u0018\u00010\n0\n2\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\nH\u0002J\u0006\u0010\u0015\u001a\u00020\nJ\u0015\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b\u0018J\u000e\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\nJ\u000e\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\nJ\u0014\u0010\u001d\u001a\u00020\b2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\n0\u000eJ\u0010\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020\nH\u0007J\u0018\u0010!\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/flybits/commons/library/SharedElements;", "", "sharedPreferences", "Landroid/content/SharedPreferences;", "userDAO", "Lcom/flybits/internal/db/UserDAO;", "(Landroid/content/SharedPreferences;Lcom/flybits/internal/db/UserDAO;)V", "clear", "", "getConnectedIDP", "", "kotlin.jvm.PlatformType", "getDeviceID", "getEnabledLanguagesAsArray", "Ljava/util/ArrayList;", "getEnabledLanguagesAsString", "getProjectID", "getSavedJWTToken", "getStringVariable", "key", "default", "getUserID", "migrateUnencrypted", "oldUnencryptedPreferences", "migrateUnencrypted$commons_release", "setConnectedIDP", "idp", "setJWTToken", "jwtToken", "setLocalization", "listOfLanguages", "setProjectID", "projectID", "setStringVariable", "value", "Companion", "commons_release"})
public final class SharedElements {
    private final SharedPreferences sharedPreferences;
    private final UserDAO userDAO;
    @NotNull
    public static final String PREF_LANGUAGE_CODES = "com.flybits.language.codes";
    @NotNull
    public static final String PREF_JWT_TOKEN = "com.flybits.jwt.token";
    @NotNull
    public static final String PREF_IDP_CONNECTED = "com.flybits.idp.connected";
    @NotNull
    public static final String PREF_PROJECT_ID = "com.flybits.project.id";
    public static final Companion Companion = new Companion(null);

    public final void migrateUnencrypted$commons_release(@NotNull SharedPreferences oldUnencryptedPreferences) {
        Intrinsics.checkParameterIsNotNull((Object)oldUnencryptedPreferences, (String)"oldUnencryptedPreferences");
        if (oldUnencryptedPreferences.contains(PREF_IDP_CONNECTED)) {
            String string = oldUnencryptedPreferences.getString(PREF_IDP_CONNECTED, "");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"oldUnencryptedPreference\u2026g(PREF_IDP_CONNECTED, \"\")");
            this.setStringVariable(PREF_IDP_CONNECTED, string);
        }
        if (oldUnencryptedPreferences.contains(PREF_PROJECT_ID)) {
            String string = oldUnencryptedPreferences.getString(PREF_PROJECT_ID, "");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"oldUnencryptedPreference\u2026ring(PREF_PROJECT_ID, \"\")");
            this.setStringVariable(PREF_PROJECT_ID, string);
        }
        if (oldUnencryptedPreferences.contains(PREF_LANGUAGE_CODES)) {
            String string = oldUnencryptedPreferences.getString(PREF_LANGUAGE_CODES, "");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"oldUnencryptedPreference\u2026(PREF_LANGUAGE_CODES, \"\")");
            this.setStringVariable(PREF_LANGUAGE_CODES, string);
        }
        if (oldUnencryptedPreferences.contains(PREF_JWT_TOKEN)) {
            String string = oldUnencryptedPreferences.getString(PREF_JWT_TOKEN, "");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"oldUnencryptedPreference\u2026tring(PREF_JWT_TOKEN, \"\")");
            this.setStringVariable(PREF_JWT_TOKEN, string);
        }
        oldUnencryptedPreferences.edit().clear().apply();
    }

    public final String getConnectedIDP() {
        return this.getStringVariable(PREF_IDP_CONNECTED, "");
    }

    @NotNull
    public final String getDeviceID() {
        String string;
        User user = this.userDAO.getSingle();
        if (user != null) {
            String string2 = user.getDeviceID();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"user.deviceID");
        } else {
            string = "";
        }
        return string;
    }

    @NotNull
    public final ArrayList<String> getEnabledLanguagesAsArray() {
        String languageCodes = this.getStringVariable(PREF_LANGUAGE_CODES, "");
        ArrayList<String> arrayList = Utilities.convertLocalizationStringToList(languageCodes);
        Intrinsics.checkExpressionValueIsNotNull(arrayList, (String)"Utilities.convertLocaliz\u2026ringToList(languageCodes)");
        return arrayList;
    }

    public final String getEnabledLanguagesAsString() {
        return this.getStringVariable(PREF_LANGUAGE_CODES, "");
    }

    public final String getProjectID() {
        return this.getStringVariable(PREF_PROJECT_ID, "");
    }

    public final String getSavedJWTToken() {
        return this.getStringVariable(PREF_JWT_TOKEN, "");
    }

    @NotNull
    public final String getUserID() {
        String string;
        User user = this.userDAO.getSingle();
        if (user != null) {
            String string2 = user.getId();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"user.id");
        } else {
            string = "";
        }
        return string;
    }

    public final void clear() {
        this.sharedPreferences.edit().clear().apply();
    }

    public final void setConnectedIDP(@NotNull String idp) {
        Intrinsics.checkParameterIsNotNull((Object)idp, (String)"idp");
        this.setStringVariable(PREF_IDP_CONNECTED, idp);
    }

    public final void setJWTToken(@NotNull String jwtToken) {
        Intrinsics.checkParameterIsNotNull((Object)jwtToken, (String)"jwtToken");
        this.setStringVariable(PREF_JWT_TOKEN, jwtToken);
    }

    public final void setLocalization(@NotNull ArrayList<String> listOfLanguages) {
        Intrinsics.checkParameterIsNotNull(listOfLanguages, (String)"listOfLanguages");
        String string = Utilities.convertLocalizationCodeToString(listOfLanguages);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Utilities.convertLocaliz\u2026ToString(listOfLanguages)");
        this.setStringVariable(PREF_LANGUAGE_CODES, string);
    }

    @Deprecated(message="Use {@link FlybitsManager.Builder#setProjectId(String)} instead as it is a more\n      optimized.")
    public final void setProjectID(@NotNull String projectID) {
        Intrinsics.checkParameterIsNotNull((Object)projectID, (String)"projectID");
        this.setStringVariable(PREF_PROJECT_ID, projectID);
    }

    private final void setStringVariable(String key, String value) {
        SharedPreferences.Editor editor = this.sharedPreferences.edit();
        editor.putString(key, value);
        editor.apply();
    }

    private final String getStringVariable(String key, String string) {
        return this.sharedPreferences.getString(key, string);
    }

    public SharedElements(@NotNull SharedPreferences sharedPreferences, @NotNull UserDAO userDAO) {
        Intrinsics.checkParameterIsNotNull((Object)sharedPreferences, (String)"sharedPreferences");
        Intrinsics.checkParameterIsNotNull((Object)userDAO, (String)"userDAO");
        this.sharedPreferences = sharedPreferences;
        this.userDAO = userDAO;
    }

    @JvmStatic
    @NotNull
    public static final SharedElements get(@NotNull Context context) {
        return Companion.get(context);
    }

    @JvmStatic
    public static final boolean enableEncryption(@NotNull Context context, @Nullable String projectId) {
        return Companion.enableEncryption(context, projectId);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0004H\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/flybits/commons/library/SharedElements$Companion;", "", "()V", "PREF_IDP_CONNECTED", "", "PREF_JWT_TOKEN", "PREF_LANGUAGE_CODES", "PREF_PROJECT_ID", "enableEncryption", "", "context", "Landroid/content/Context;", "projectId", "get", "Lcom/flybits/commons/library/SharedElements;", "commons_release"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final SharedElements get(@NotNull Context context) {
            SharedElements sharedElements;
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            UserDAO userDAO = CommonsDatabase.getDatabase(context).userDao();
            try {
                SecuredPreferenceStore securedPreferenceStore = SecuredPreferenceStore.getSharedInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)securedPreferenceStore, (String)"SecuredPreferenceStore.getSharedInstance()");
                SharedPreferences sharedPreferences = (SharedPreferences)securedPreferenceStore;
                UserDAO userDAO2 = userDAO;
                Intrinsics.checkExpressionValueIsNotNull((Object)userDAO2, (String)"userDAO");
                sharedElements = new SharedElements(sharedPreferences, userDAO2);
            }
            catch (Exception e) {
                SharedPreferences sharedPreferences = context.getSharedPreferences("FLYBITS_PREF_BACKUP", 0);
                Intrinsics.checkExpressionValueIsNotNull((Object)sharedPreferences, (String)"context.getSharedPrefere\u2026EF_BACKUP\", MODE_PRIVATE)");
                UserDAO userDAO3 = userDAO;
                Intrinsics.checkExpressionValueIsNotNull((Object)userDAO3, (String)"userDAO");
                sharedElements = new SharedElements(sharedPreferences, userDAO3);
            }
            return sharedElements;
        }

        @JvmStatic
        public final boolean enableEncryption(@NotNull Context context, @Nullable String projectId) {
            boolean bl;
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            try {
                SecuredPreferenceStore.init((Context)context, (String)"flybits_con_storage", (String)projectId, null, (RecoveryHandler)((RecoveryHandler)new DefaultRecoveryHandler()));
                SharedElements sharedElements = Companion.get(context);
                SharedPreferences sharedPreferences = context.getSharedPreferences("FLYBITS_PREF", 0);
                Intrinsics.checkExpressionValueIsNotNull((Object)sharedPreferences, (String)"context.getSharedPrefere\u2026F\", Context.MODE_PRIVATE)");
                sharedElements.migrateUnencrypted$commons_release(sharedPreferences);
                bl = true;
            }
            catch (Exception e) {
                Logger.exception("SharedElements.enableEncryption", e);
                bl = false;
            }
            return bl;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

