package com.flybits.commons.library.api;

import android.content.Context;

import com.flybits.commons.library.SharedElements;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.http.HttpDefaultClass;
import com.flybits.commons.library.logging.Logger;
import com.flybits.commons.library.models.internal.Result;

import java.io.IOException;

public class FlyJWT {

    static String ENDPOINT_JWT  = FlybitsManager.AUTHENTICATION_API+"/refreshToken";

    public static Result refreshJWT(Context context) throws FlybitsException {

        if (SharedElements.get(context).getSavedJWTToken().equalsIgnoreCase("")){
            return new Result(401, "");
        }

        String url = FlybitsAPIConstants.constructGatewayURL(context, ENDPOINT_JWT);

        try {
            return new HttpDefaultClass.Builder(context, false, url)
                    .get().getResponse();
        } catch (IOException | NullPointerException e) {
            Logger.exception("FlyJWT.refreshJWT", e);
            throw new FlybitsException("Error Connecting to Flybits Server: FlyException_JWT1");
        }
    }
}
