/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library;

import android.content.Context;
import android.content.SharedPreferences;
import com.flybits.commons.library.models.User;
import com.flybits.commons.library.utils.Utilities;
import com.flybits.internal.db.CommonsDatabase;
import com.flybits.internal.db.UserDAO;
import devliving.online.securedpreferencestore.SecuredPreferenceStore;
import java.util.ArrayList;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\n \t*\u0004\u0018\u00010\u00040\u0004J\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fJ\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eJ\u000e\u0010\u000f\u001a\n \t*\u0004\u0018\u00010\u00040\u0004J\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\n \t*\u0004\u0018\u00010\u00040\u0004J\u000e\u0010\u0013\u001a\n \t*\u0004\u0018\u00010\u00040\u0004J \u0010\u0014\u001a\n \t*\u0004\u0018\u00010\u00040\u00042\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0002J\u000e\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0004J\u000e\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u0004J\u0014\u0010\u001e\u001a\u00020\u00192\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eJ\u0010\u0010 \u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u0004H\u0007J\u0018\u0010\"\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/flybits/commons/library/SharedElements;", "", "()V", "PREF_IDP_CONNECTED", "", "PREF_JWT_TOKEN", "PREF_LANGUAGE_CODES", "PREF_PROJECT_ID", "getConnectedIDP", "kotlin.jvm.PlatformType", "getDeviceID", "context", "Landroid/content/Context;", "getEnabledLanguagesAsArray", "Ljava/util/ArrayList;", "getEnabledLanguagesAsString", "getPreferences", "Landroid/content/SharedPreferences;", "getProjectID", "getSavedJWTToken", "getStringVariable", "key", "default", "getUserID", "migrateUnencrypted", "", "setConnectedIDP", "idp", "setJWTToken", "jwtToken", "setLocalization", "listOfLanguages", "setProjectID", "projectID", "setStringVariable", "value", "commons_release"})
public final class SharedElements {
    @NotNull
    public static final String PREF_LANGUAGE_CODES = "com.flybits.language.codes";
    @NotNull
    public static final String PREF_JWT_TOKEN = "com.flybits.jwt.token";
    @NotNull
    public static final String PREF_IDP_CONNECTED = "com.flybits.idp.connected";
    @NotNull
    public static final String PREF_PROJECT_ID = "com.flybits.project.id";
    public static final SharedElements INSTANCE;

    public final void migrateUnencrypted(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        SharedPreferences oldUnencryptedPreferences = context.getSharedPreferences("FLYBITS_PREF", 0);
        if (oldUnencryptedPreferences.contains(PREF_IDP_CONNECTED)) {
            String string = oldUnencryptedPreferences.getString(PREF_IDP_CONNECTED, "");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"oldUnencryptedPreference\u2026g(PREF_IDP_CONNECTED, \"\")");
            this.setStringVariable(PREF_IDP_CONNECTED, string);
        }
        if (oldUnencryptedPreferences.contains(PREF_PROJECT_ID)) {
            String string = oldUnencryptedPreferences.getString(PREF_PROJECT_ID, "");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"oldUnencryptedPreference\u2026ring(PREF_PROJECT_ID, \"\")");
            this.setStringVariable(PREF_PROJECT_ID, string);
        }
        if (oldUnencryptedPreferences.contains(PREF_LANGUAGE_CODES)) {
            String string = oldUnencryptedPreferences.getString(PREF_LANGUAGE_CODES, "");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"oldUnencryptedPreference\u2026(PREF_LANGUAGE_CODES, \"\")");
            this.setStringVariable(PREF_LANGUAGE_CODES, string);
        }
        if (oldUnencryptedPreferences.contains(PREF_JWT_TOKEN)) {
            String string = oldUnencryptedPreferences.getString(PREF_JWT_TOKEN, "");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"oldUnencryptedPreference\u2026tring(PREF_JWT_TOKEN, \"\")");
            this.setStringVariable(PREF_JWT_TOKEN, string);
        }
        oldUnencryptedPreferences.edit().clear().apply();
    }

    public final String getConnectedIDP() {
        return this.getStringVariable(PREF_IDP_CONNECTED, "");
    }

    @NotNull
    public final String getDeviceID(@NotNull Context context) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        UserDAO userDAO = CommonsDatabase.getDatabase(context).userDao();
        Intrinsics.checkExpressionValueIsNotNull((Object)userDAO, (String)"CommonsDatabase.getDatabase(context).userDao()");
        User user = userDAO.getSingle();
        if (user != null) {
            String string2 = user.getDeviceID();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"user.deviceID");
        } else {
            string = "";
        }
        return string;
    }

    @NotNull
    public final ArrayList<String> getEnabledLanguagesAsArray() {
        String languageCodes = this.getStringVariable(PREF_LANGUAGE_CODES, "");
        ArrayList<String> arrayList = Utilities.convertLocalizationStringToList(languageCodes);
        Intrinsics.checkExpressionValueIsNotNull(arrayList, (String)"Utilities.convertLocaliz\u2026ringToList(languageCodes)");
        return arrayList;
    }

    public final String getEnabledLanguagesAsString() {
        return this.getStringVariable(PREF_LANGUAGE_CODES, "");
    }

    public final String getProjectID() {
        return this.getStringVariable(PREF_PROJECT_ID, "");
    }

    public final String getSavedJWTToken() {
        return this.getStringVariable(PREF_JWT_TOKEN, "");
    }

    @NotNull
    public final String getUserID(@NotNull Context context) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        UserDAO userDAO = CommonsDatabase.getDatabase(context).userDao();
        Intrinsics.checkExpressionValueIsNotNull((Object)userDAO, (String)"CommonsDatabase.getDatabase(context).userDao()");
        User user = userDAO.getSingle();
        if (user != null) {
            String string2 = user.getId();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"user.id");
        } else {
            string = "";
        }
        return string;
    }

    public final void setConnectedIDP(@NotNull String idp) {
        Intrinsics.checkParameterIsNotNull((Object)idp, (String)"idp");
        this.setStringVariable(PREF_IDP_CONNECTED, idp);
    }

    public final void setJWTToken(@NotNull String jwtToken) {
        Intrinsics.checkParameterIsNotNull((Object)jwtToken, (String)"jwtToken");
        this.setStringVariable(PREF_JWT_TOKEN, jwtToken);
    }

    public final void setLocalization(@NotNull ArrayList<String> listOfLanguages) {
        Intrinsics.checkParameterIsNotNull(listOfLanguages, (String)"listOfLanguages");
        String string = Utilities.convertLocalizationCodeToString(listOfLanguages);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Utilities.convertLocaliz\u2026ToString(listOfLanguages)");
        this.setStringVariable(PREF_LANGUAGE_CODES, string);
    }

    @Deprecated(message="Use {@link FlybitsManager.Builder#setProjectId(String)} instead as it is a more\n      optimized.")
    public final void setProjectID(@NotNull String projectID) {
        Intrinsics.checkParameterIsNotNull((Object)projectID, (String)"projectID");
        this.setStringVariable(PREF_PROJECT_ID, projectID);
    }

    @NotNull
    public final SharedPreferences getPreferences() {
        SecuredPreferenceStore securedPreferenceStore = SecuredPreferenceStore.getSharedInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)securedPreferenceStore, (String)"SecuredPreferenceStore.getSharedInstance()");
        return (SharedPreferences)securedPreferenceStore;
    }

    private final void setStringVariable(String key, String value) {
        SharedPreferences.Editor editor = this.getPreferences().edit();
        editor.putString(key, value);
        editor.apply();
    }

    private final String getStringVariable(String key, String string) {
        return this.getPreferences().getString(key, string);
    }

    private SharedElements() {
    }

    static {
        SharedElements sharedElements;
        INSTANCE = sharedElements = new SharedElements();
    }
}

