package com.flybits.internal.db;

import android.arch.lifecycle.LiveData;
import android.arch.persistence.room.Dao;
import android.arch.persistence.room.Insert;
import android.arch.persistence.room.OnConflictStrategy;
import android.arch.persistence.room.Query;

import com.flybits.internal.db.models.CachingEntry;

import java.util.List;

@Dao
public interface CachingEntryDAO {

    /**
     * GET
     */
    @Query("SELECT contentID FROM cachingentry WHERE cachingkey = :key order by sequence ASC")
    List<String> getIdsByCachingKey(String key);

    //Selects only the content ids which only appear across the entire table once, if two caching entries contain the same content id, they will not be returned here.
    @Query("SELECT contentId FROM ( SELECT contentID, sequence, cachingkey FROM cachingentry GROUP BY contentID HAVING COUNT(contentID) = 1 ) WHERE cachingkey = :key ORDER BY sequence ASC")
    List<String> getUniqueIdsByCachingKey(String key);

    @Query("SELECT * FROM cachingentry WHERE cachingkey = :key order by sequence ASC")
    List<CachingEntry> getByKey(String key);

    /**
     * CREATE/INSERT/DELETE
     */
    @Insert(onConflict = OnConflictStrategy.REPLACE)
    void insert(CachingEntry entry);

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    void insert(List<CachingEntry> entry);

    @Query("Delete from cachingentry")
    void clear();

    @Query("Delete from cachingentry WHERE cachingkey = :key")
    void deleteAllByCachingKey(String key);

    /**
     * LIVEDATA
     */
    @Query("SELECT * FROM cachingentry WHERE cachingkey = :key order by sequence ASC")
    LiveData<List<CachingEntry>> getLive(String key);
}
