/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.utils.jbool_expressions;

import com.flybits.commons.library.utils.jbool_expressions.CollapseNegation;
import com.flybits.commons.library.utils.jbool_expressions.CombineAnd;
import com.flybits.commons.library.utils.jbool_expressions.CombineOr;
import com.flybits.commons.library.utils.jbool_expressions.DeMorgan;
import com.flybits.commons.library.utils.jbool_expressions.Expression;
import com.flybits.commons.library.utils.jbool_expressions.Rule;
import com.flybits.commons.library.utils.jbool_expressions.SimplifyAnd;
import com.flybits.commons.library.utils.jbool_expressions.SimplifyNExprChildren;
import com.flybits.commons.library.utils.jbool_expressions.SimplifyNExpression;
import com.flybits.commons.library.utils.jbool_expressions.SimplifyNot;
import com.flybits.commons.library.utils.jbool_expressions.SimplifyOr;
import com.flybits.commons.library.utils.jbool_expressions.ToSOP;
import java.util.ArrayList;
import java.util.List;

class RulesHelper {
    RulesHelper() {
    }

    public static <K> List<Rule<?, K>> simplifyRules() {
        ArrayList rules = new ArrayList();
        rules.add(new SimplifyAnd());
        rules.add(new SimplifyOr());
        rules.add(new SimplifyNot());
        rules.add(new CombineAnd());
        rules.add(new CombineOr());
        rules.add(new SimplifyNExpression());
        rules.add(new SimplifyNExprChildren());
        rules.add(new CollapseNegation());
        return rules;
    }

    public static <K> List<Rule<?, K>> toSopRules() {
        ArrayList rules = new ArrayList(RulesHelper.simplifyRules());
        rules.add(new ToSOP());
        return rules;
    }

    public static <K> List<Rule<?, K>> demorganRules() {
        ArrayList rules = new ArrayList(RulesHelper.simplifyRules());
        rules.add(new DeMorgan());
        return rules;
    }

    public static <K> Expression<K> applyAll(Expression<K> e, List<Rule<?, K>> rules) {
        Expression<K> orig = e;
        Expression<K> simplified = RulesHelper.applyAllSingle(orig, rules);
        while (!orig.equals(simplified)) {
            orig = simplified;
            simplified = RulesHelper.applyAllSingle(orig, rules);
        }
        return simplified;
    }

    private static <K> Expression<K> applyAllSingle(Expression<K> e, List<Rule<?, K>> rules) {
        Expression<K> tmp = e.apply(rules);
        for (Rule<?, K> r : rules) {
            tmp = r.apply(tmp);
        }
        return tmp;
    }

    public static <K> Expression<K> applySet(Expression<K> root, List<Rule<?, K>> allRules) {
        return RulesHelper.applyAll(root, allRules);
    }
}

