/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.utils;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Build;
import android.os.Bundle;
import com.flybits.commons.library.DefaultUniqueDeviceIdGenerator;
import com.flybits.commons.library.SharedElements;
import com.flybits.commons.library.SharedElementsFactory;
import com.flybits.commons.library.logging.Logger;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import java.util.ArrayList;
import java.util.Arrays;
import org.json.JSONException;
import org.json.JSONObject;

public class Utilities {
    public static ArrayList<String> convertLocalizationStringToList(String languageCodeAsString) {
        if (languageCodeAsString == null || languageCodeAsString.length() == 0) {
            return new ArrayList<String>();
        }
        String[] listOfCodes = languageCodeAsString.split(",");
        return new ArrayList<String>(Arrays.asList(listOfCodes));
    }

    public static String convertLocalizationCodeToString(ArrayList<String> listOfCodes) {
        if (listOfCodes != null && listOfCodes.size() > 0) {
            String languageCodeString = listOfCodes.get(0);
            for (int i = 1; i < listOfCodes.size(); ++i) {
                languageCodeString = languageCodeString.concat("," + listOfCodes.get(i));
            }
            return languageCodeString;
        }
        return "";
    }

    public static String getSDKVersion() {
        return "1.20.0-alpha3";
    }

    public static String getUserAgentAsJSON(Context context) {
        JSONObject obj = new JSONObject();
        try {
            obj.put("make", (Object)Build.MANUFACTURER);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            obj.put("model", (Object)Build.MODEL);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            obj.put("osVersion", (Object)String.valueOf(Build.VERSION.SDK_INT));
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            obj.put("deviceType", (Object)"Android");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            SharedElements sharedElements = SharedElementsFactory.INSTANCE.get(context);
            DefaultUniqueDeviceIdGenerator uniqueDeviceIdGenerator = new DefaultUniqueDeviceIdGenerator(AdvertisingIdClient.getAdvertisingIdInfo((Context)context));
            if (!sharedElements.getUniqueDeviceId().isEmpty()) {
                obj.put("physicalDeviceId", (Object)sharedElements.getUniqueDeviceId());
            } else {
                String uniqueDeviceId = uniqueDeviceIdGenerator.generateUniqueDeviceId();
                if (!uniqueDeviceId.isEmpty()) {
                    obj.put("physicalDeviceId", (Object)uniqueDeviceId);
                }
            }
        }
        catch (Exception sharedElements) {
            // empty catch block
        }
        try {
            obj.put("sdkVersion", (Object)Utilities.getSDKVersion());
        }
        catch (JSONException sharedElements) {
            // empty catch block
        }
        try {
            ApplicationInfo ai = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            Bundle bundle = ai.metaData;
            if (bundle.containsKey("com.flybits.device.name")) {
                String name = bundle.getString("com.flybits.device.name");
                obj.put("name", (Object)name);
            } else {
                obj.put("name", (Object)(Build.MANUFACTURER + "-" + Build.MODEL));
            }
        }
        catch (Exception e) {
            Logger.exception("getUserAgentAsJSON", e);
        }
        return obj.toString();
    }
}

