package com.flybits.commons.library.utils.jbool_expressions;

import static com.flybits.commons.library.utils.jbool_expressions.RulesHelper.applySet;

//  intended user facing methods
public class RuleSet {

  private static final int QMC_CARDINALITY_CUTOFF = 8;

  static <K> Expression<K> toSop(Expression<K> root) {
    return applySet(applySet(root, RulesHelper.<K>demorganRules()), RulesHelper.<K>toSopRules());
  }

  static <K> Expression<K> toPos(Expression<K> root) {

    //   not + toDNF
    Not<K> inverse = Not.of(root);
    Expression<K> sopInv = toSop(inverse);

    //  not + demorgan
    Not<K> inverse2 = Not.of(sopInv);

    return (applySet(inverse2, RulesHelper.<K>demorganRules()));
  }

  /**
   * More formal name for sum-of-products
   */
  private static <K> Expression<K> toDNF(Expression<K> root) {
    return toSop(root);
  }

  /**
   * More formal name for product-of-sums
   */
  public static <K> Expression<K> toCNF(Expression<K> root) {
    return toPos(root);
  }

}
