package com.flybits.commons.library.utils.jbool_expressions;

import static com.flybits.commons.library.utils.jbool_expressions.ExprUtil.collapseToSOP;

class ToSOP<K> extends Rule<And<K>, K> {

  @Override
  public Expression<K> applyInternal(And<K> and) {
    //  if there are any children which are ORs,
    for (Expression<K> e : and.expressions) {
      if (e instanceof Or) {
        Or<K> or = (Or<K>) e;

        return collapseToSOP(and, or, null);
      }
    }
    return and;
  }

  @Override
  protected boolean isApply(Expression<K> input) {
    return input instanceof And;
  }
}