package com.flybits.commons.library.api

/**
 * The [CustomerStatus] is used to indicate the customerID status
 * with respect to jwt.
 */
enum class CustomerStatus {

    /**
     * Indicates that customer is connected and opted in to Flybits Server.
     */
    CONNECTED_OPTED_IN,

    /**
     * Indicates that customer is connected but opted out of Flybits Server.
     */
    CONNECTED_OPTED_OUT,

    /**
     * Indicates that customer is connected and opted in of Flybits Server but JWT is expired.
     */
    CONNECTED_OPTED_IN_EXPIRED_TOKEN,

    /**
     * Indicates that customer is connected and opted out of Flybits Server but JWT is expired.
     */
    CONNECTED_OPTED_OUT_EXPIRED_TOKEN,

    /**
     * Indicates that customer is not connected but opted in to Flybits Server.
     */
    NOT_CONNECTED_OPTED_IN,

    /**
     * Indicates that customer is not connected and opted out of Flybits Server.
     */
    NOT_CONNECTED_OPTED_OUT,

    /**
     * Indicates that customer is not connected and its opt in status in unknown.
     */
    NOT_CONNECTED,
}