/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.internal.db;

import android.arch.persistence.db.SupportSQLiteDatabase;
import android.arch.persistence.db.SupportSQLiteOpenHelper;
import android.arch.persistence.room.DatabaseConfiguration;
import android.arch.persistence.room.InvalidationTracker;
import android.arch.persistence.room.RoomDatabase;
import android.arch.persistence.room.RoomOpenHelper;
import android.arch.persistence.room.util.TableInfo;
import android.content.Context;
import com.flybits.internal.db.CachingEntryDAO;
import com.flybits.internal.db.CachingEntryDAO_Impl;
import com.flybits.internal.db.CommonsDatabase;
import com.flybits.internal.db.CtxDataDAO;
import com.flybits.internal.db.CtxDataDAO_Impl;
import com.flybits.internal.db.PreferenceDAO;
import com.flybits.internal.db.PreferenceDAO_Impl;
import com.flybits.internal.db.UserDAO;
import com.flybits.internal.db.UserDAO_Impl;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;

public class CommonsDatabase_Impl
extends CommonsDatabase {
    private volatile UserDAO _userDAO;
    private volatile CachingEntryDAO _cachingEntryDAO;
    private volatile PreferenceDAO _preferenceDAO;
    private volatile CtxDataDAO _ctxDataDAO;

    protected SupportSQLiteOpenHelper createOpenHelper(DatabaseConfiguration configuration) {
        RoomOpenHelper _openCallback = new RoomOpenHelper(configuration, new RoomOpenHelper.Delegate(8){

            public void createAllTables(SupportSQLiteDatabase _db) {
                _db.execSQL("CREATE TABLE IF NOT EXISTS `user` (`deviceID` TEXT, `email` TEXT, `firstName` TEXT, `id` TEXT NOT NULL, `lastName` TEXT, `isVerified` INTEGER NOT NULL, `isOptedIn` INTEGER NOT NULL, `isActive` INTEGER NOT NULL, `customerID` TEXT, PRIMARY KEY(`id`))");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `cachingentry` (`cachingkey` TEXT NOT NULL, `contentID` TEXT NOT NULL, `sequence` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL)");
                _db.execSQL("CREATE UNIQUE INDEX `index_cachingentry_cachingkey_contentID` ON `cachingentry` (`cachingkey`, `contentID`)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `preferences` (`prefKey` TEXT NOT NULL, `value` TEXT NOT NULL, PRIMARY KEY(`prefKey`, `value`))");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `ctxData` (`id` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `timestamp` INTEGER NOT NULL, `value` TEXT NOT NULL)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS room_master_table (id INTEGER PRIMARY KEY,identity_hash TEXT)");
                _db.execSQL("INSERT OR REPLACE INTO room_master_table (id,identity_hash) VALUES(42, \"c4cd76e50a65eb6cb253f6229623b765\")");
            }

            public void dropAllTables(SupportSQLiteDatabase _db) {
                _db.execSQL("DROP TABLE IF EXISTS `user`");
                _db.execSQL("DROP TABLE IF EXISTS `cachingentry`");
                _db.execSQL("DROP TABLE IF EXISTS `preferences`");
                _db.execSQL("DROP TABLE IF EXISTS `ctxData`");
            }

            protected void onCreate(SupportSQLiteDatabase _db) {
                if (CommonsDatabase_Impl.this.mCallbacks != null) {
                    int _size = CommonsDatabase_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)CommonsDatabase_Impl.this.mCallbacks.get(_i)).onCreate(_db);
                    }
                }
            }

            public void onOpen(SupportSQLiteDatabase _db) {
                CommonsDatabase_Impl.this.mDatabase = _db;
                CommonsDatabase_Impl.this.internalInitInvalidationTracker(_db);
                if (CommonsDatabase_Impl.this.mCallbacks != null) {
                    int _size = CommonsDatabase_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)CommonsDatabase_Impl.this.mCallbacks.get(_i)).onOpen(_db);
                    }
                }
            }

            protected void validateMigration(SupportSQLiteDatabase _db) {
                HashMap<String, TableInfo.Column> _columnsUser = new HashMap<String, TableInfo.Column>(9);
                _columnsUser.put("deviceID", new TableInfo.Column("deviceID", "TEXT", false, 0));
                _columnsUser.put("email", new TableInfo.Column("email", "TEXT", false, 0));
                _columnsUser.put("firstName", new TableInfo.Column("firstName", "TEXT", false, 0));
                _columnsUser.put("id", new TableInfo.Column("id", "TEXT", true, 1));
                _columnsUser.put("lastName", new TableInfo.Column("lastName", "TEXT", false, 0));
                _columnsUser.put("isVerified", new TableInfo.Column("isVerified", "INTEGER", true, 0));
                _columnsUser.put("isOptedIn", new TableInfo.Column("isOptedIn", "INTEGER", true, 0));
                _columnsUser.put("isActive", new TableInfo.Column("isActive", "INTEGER", true, 0));
                _columnsUser.put("customerID", new TableInfo.Column("customerID", "TEXT", false, 0));
                HashSet _foreignKeysUser = new HashSet(0);
                HashSet _indicesUser = new HashSet(0);
                TableInfo _infoUser = new TableInfo("user", _columnsUser, _foreignKeysUser, _indicesUser);
                TableInfo _existingUser = TableInfo.read((SupportSQLiteDatabase)_db, (String)"user");
                if (!_infoUser.equals((Object)_existingUser)) {
                    throw new IllegalStateException("Migration didn't properly handle user(com.flybits.commons.library.models.User).\n Expected:\n" + _infoUser + "\n Found:\n" + _existingUser);
                }
                HashMap<String, TableInfo.Column> _columnsCachingentry = new HashMap<String, TableInfo.Column>(3);
                _columnsCachingentry.put("cachingkey", new TableInfo.Column("cachingkey", "TEXT", true, 0));
                _columnsCachingentry.put("contentID", new TableInfo.Column("contentID", "TEXT", true, 0));
                _columnsCachingentry.put("sequence", new TableInfo.Column("sequence", "INTEGER", true, 1));
                HashSet _foreignKeysCachingentry = new HashSet(0);
                HashSet<TableInfo.Index> _indicesCachingentry = new HashSet<TableInfo.Index>(1);
                _indicesCachingentry.add(new TableInfo.Index("index_cachingentry_cachingkey_contentID", true, Arrays.asList("cachingkey", "contentID")));
                TableInfo _infoCachingentry = new TableInfo("cachingentry", _columnsCachingentry, _foreignKeysCachingentry, _indicesCachingentry);
                TableInfo _existingCachingentry = TableInfo.read((SupportSQLiteDatabase)_db, (String)"cachingentry");
                if (!_infoCachingentry.equals((Object)_existingCachingentry)) {
                    throw new IllegalStateException("Migration didn't properly handle cachingentry(com.flybits.internal.db.models.CachingEntry).\n Expected:\n" + _infoCachingentry + "\n Found:\n" + _existingCachingentry);
                }
                HashMap<String, TableInfo.Column> _columnsPreferences = new HashMap<String, TableInfo.Column>(2);
                _columnsPreferences.put("prefKey", new TableInfo.Column("prefKey", "TEXT", true, 1));
                _columnsPreferences.put("value", new TableInfo.Column("value", "TEXT", true, 2));
                HashSet _foreignKeysPreferences = new HashSet(0);
                HashSet _indicesPreferences = new HashSet(0);
                TableInfo _infoPreferences = new TableInfo("preferences", _columnsPreferences, _foreignKeysPreferences, _indicesPreferences);
                TableInfo _existingPreferences = TableInfo.read((SupportSQLiteDatabase)_db, (String)"preferences");
                if (!_infoPreferences.equals((Object)_existingPreferences)) {
                    throw new IllegalStateException("Migration didn't properly handle preferences(com.flybits.internal.db.models.Preference).\n Expected:\n" + _infoPreferences + "\n Found:\n" + _existingPreferences);
                }
                HashMap<String, TableInfo.Column> _columnsCtxData = new HashMap<String, TableInfo.Column>(3);
                _columnsCtxData.put("id", new TableInfo.Column("id", "INTEGER", true, 1));
                _columnsCtxData.put("timestamp", new TableInfo.Column("timestamp", "INTEGER", true, 0));
                _columnsCtxData.put("value", new TableInfo.Column("value", "TEXT", true, 0));
                HashSet _foreignKeysCtxData = new HashSet(0);
                HashSet _indicesCtxData = new HashSet(0);
                TableInfo _infoCtxData = new TableInfo("ctxData", _columnsCtxData, _foreignKeysCtxData, _indicesCtxData);
                TableInfo _existingCtxData = TableInfo.read((SupportSQLiteDatabase)_db, (String)"ctxData");
                if (!_infoCtxData.equals((Object)_existingCtxData)) {
                    throw new IllegalStateException("Migration didn't properly handle ctxData(com.flybits.commons.library.models.CtxData).\n Expected:\n" + _infoCtxData + "\n Found:\n" + _existingCtxData);
                }
            }
        }, "c4cd76e50a65eb6cb253f6229623b765", "c9914ad381012e492b4e327627fdfd28");
        SupportSQLiteOpenHelper.Configuration _sqliteConfig = SupportSQLiteOpenHelper.Configuration.builder((Context)configuration.context).name(configuration.name).callback((SupportSQLiteOpenHelper.Callback)_openCallback).build();
        SupportSQLiteOpenHelper _helper = configuration.sqliteOpenHelperFactory.create(_sqliteConfig);
        return _helper;
    }

    protected InvalidationTracker createInvalidationTracker() {
        return new InvalidationTracker((RoomDatabase)this, new String[]{"user", "cachingentry", "preferences", "ctxData"});
    }

    public void clearAllTables() {
        super.assertNotMainThread();
        SupportSQLiteDatabase _db = super.getOpenHelper().getWritableDatabase();
        try {
            super.beginTransaction();
            _db.execSQL("DELETE FROM `user`");
            _db.execSQL("DELETE FROM `cachingentry`");
            _db.execSQL("DELETE FROM `preferences`");
            _db.execSQL("DELETE FROM `ctxData`");
            super.setTransactionSuccessful();
        }
        finally {
            super.endTransaction();
            _db.query("PRAGMA wal_checkpoint(FULL)").close();
            if (!_db.inTransaction()) {
                _db.execSQL("VACUUM");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserDAO userDao() {
        if (this._userDAO != null) {
            return this._userDAO;
        }
        CommonsDatabase_Impl commonsDatabase_Impl = this;
        synchronized (commonsDatabase_Impl) {
            if (this._userDAO == null) {
                this._userDAO = new UserDAO_Impl(this);
            }
            return this._userDAO;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CachingEntryDAO cachingEntryDAO() {
        if (this._cachingEntryDAO != null) {
            return this._cachingEntryDAO;
        }
        CommonsDatabase_Impl commonsDatabase_Impl = this;
        synchronized (commonsDatabase_Impl) {
            if (this._cachingEntryDAO == null) {
                this._cachingEntryDAO = new CachingEntryDAO_Impl(this);
            }
            return this._cachingEntryDAO;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreferenceDAO preferenceDAO() {
        if (this._preferenceDAO != null) {
            return this._preferenceDAO;
        }
        CommonsDatabase_Impl commonsDatabase_Impl = this;
        synchronized (commonsDatabase_Impl) {
            if (this._preferenceDAO == null) {
                this._preferenceDAO = new PreferenceDAO_Impl(this);
            }
            return this._preferenceDAO;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CtxDataDAO ctxDataDAO() {
        if (this._ctxDataDAO != null) {
            return this._ctxDataDAO;
        }
        CommonsDatabase_Impl commonsDatabase_Impl = this;
        synchronized (commonsDatabase_Impl) {
            if (this._ctxDataDAO == null) {
                this._ctxDataDAO = new CtxDataDAO_Impl(this);
            }
            return this._ctxDataDAO;
        }
    }
}

