package com.flybits.commons.library.http;

/**
 * Network Response Status Codes.
 *
 * @author Petar Kramaric
 */
public enum RequestStatus {

    /**
     * API usage limit has been exceeded by the Project
     */
    API_USAGE_EXCEEDED,

    /**
     * The network request was successful.
     */
    COMPLETED,

    /**
     * The network request failed with the server providing a reason for failure.
     */
    FAILED,

    /**
     * The network request failed as the resource was not found.
     */
    NOT_FOUND,

    /**
     * Indicates that the user is currently not connected to Flybits.
     */
    NOT_CONNECTED,

    /**
     * Indicates that the user is currently opted out of Flybits.
     */
    OPTED_OUT,

    /**
     * Indicates that the request is still processing the Network Request.
     */
    PROCESSING
}
