/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.api.results;

import android.content.Context;
import android.os.Handler;
import com.flybits.commons.library.api.results.FlybitsResult;
import com.flybits.commons.library.api.results.callbacks.PagedResultCallback;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.http.RequestStatus;
import com.flybits.commons.library.models.internal.PagedResponse;
import com.flybits.commons.library.models.internal.Pagination;
import com.flybits.commons.library.models.internal.QueryParameters;
import com.flybits.commons.library.models.internal.Result;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B=\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u0018\u001a\u00020\u00192\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\bJ-\u0010\u001a\u001a\u00020\u0019\"\b\b\u0001\u0010\u001b*\u00020\u00062\u0006\u0010\u001c\u001a\u0002H\u001b2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bH&\u00a2\u0006\u0002\u0010\u001dJ\b\u0010\u001e\u001a\u00020\u001fH\u0002J(\u0010 \u001a\u00020\u00192\u0016\u0010!\u001a\u0012\u0012\u0004\u0012\u00028\u00000\"j\b\u0012\u0004\u0012\u00028\u0000`#2\u0006\u0010$\u001a\u00020%H\u0002J\u0015\u0010&\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020(H\u0000\u00a2\u0006\u0002\b)J\u001a\u0010*\u001a\u00020\u00192\u0012\u0010+\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000-0,J-\u0010.\u001a\u00020\u00192\u0016\u0010!\u001a\u0012\u0012\u0004\u0012\u00028\u00000\"j\b\u0012\u0004\u0012\u00028\u0000`#2\u0006\u0010$\u001a\u00020%H\u0000\u00a2\u0006\u0002\b/R\u0019\u0010\u0007\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/flybits/commons/library/api/results/PagedResult;", "T", "Lcom/flybits/commons/library/api/results/FlybitsResult;", "context", "Landroid/content/Context;", "filters", "Lcom/flybits/commons/library/models/internal/QueryParameters;", "callback", "Lcom/flybits/commons/library/api/results/callbacks/PagedResultCallback;", "handler", "Landroid/os/Handler;", "service", "Ljava/util/concurrent/ExecutorService;", "(Landroid/content/Context;Lcom/flybits/commons/library/models/internal/QueryParameters;Lcom/flybits/commons/library/api/results/callbacks/PagedResultCallback;Landroid/os/Handler;Ljava/util/concurrent/ExecutorService;)V", "getCallback", "()Lcom/flybits/commons/library/api/results/callbacks/PagedResultCallback;", "getContext", "()Landroid/content/Context;", "currentOffset", "", "getHandler", "()Landroid/os/Handler;", "limit", "totalItems", "getMore", "", "getMoreRequest", "K", "filter", "(Lcom/flybits/commons/library/models/internal/QueryParameters;Lcom/flybits/commons/library/api/results/callbacks/PagedResultCallback;)V", "hasMore", "", "postSuccess", "items", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "pagination", "Lcom/flybits/commons/library/models/internal/Pagination;", "setFailed", "e", "Lcom/flybits/commons/library/exceptions/FlybitsException;", "setFailed$commons_release", "setResult", "result", "Lcom/flybits/commons/library/models/internal/Result;", "Lcom/flybits/commons/library/models/internal/PagedResponse;", "setSuccess", "setSuccess$commons_release", "commons_release"})
public abstract class PagedResult<T>
extends FlybitsResult {
    private long currentOffset;
    private long limit;
    private long totalItems;
    @NotNull
    private final Context context;
    private final QueryParameters filters;
    @Nullable
    private final PagedResultCallback<T> callback;
    @Nullable
    private final Handler handler;

    public final void getMore(@Nullable PagedResultCallback<T> callback) {
        if (!this.hasMore()) {
            PagedResultCallback<T> requestCallback;
            PagedResultCallback<T> pagedResultCallback = callback;
            if (pagedResultCallback == null) {
                pagedResultCallback = requestCallback = this.callback;
            }
            if (requestCallback != null) {
                Handler handler = this.handler;
                if (handler != null) {
                    handler.post(new Runnable(requestCallback){
                        final /* synthetic */ PagedResultCallback $requestCallback;

                        public final void run() {
                            this.$requestCallback.onLoadedAllItems();
                        }
                        {
                            this.$requestCallback = pagedResultCallback;
                        }
                    });
                } else {
                    requestCallback.onLoadedAllItems();
                }
            }
            return;
        }
        this.filters.setPaging(this.limit, this.currentOffset);
        if (callback == null) {
            this.getMoreRequest(this.filters, new PagedResultCallback<T>(this){
                final /* synthetic */ PagedResult this$0;

                public void onSuccess(@NotNull ArrayList<T> items, @NotNull Pagination pagination) {
                    Intrinsics.checkParameterIsNotNull(items, (String)"items");
                    Intrinsics.checkParameterIsNotNull((Object)pagination, (String)"pagination");
                    this.this$0.setSuccess$commons_release(items, pagination);
                }

                public void onException(@NotNull FlybitsException exception) {
                    Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
                    this.this$0.setFailed$commons_release(exception);
                }

                public void onLoadedAllItems() {
                }
                {
                    this.this$0 = $outer;
                }
            });
        } else {
            this.getMoreRequest(this.filters, callback);
        }
    }

    public static /* synthetic */ void getMore$default(PagedResult pagedResult, PagedResultCallback pagedResultCallback, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getMore");
        }
        if ((n & 1) != 0) {
            pagedResultCallback = null;
        }
        pagedResult.getMore(pagedResultCallback);
    }

    public final void setResult(@NotNull Result<PagedResponse<T>> result) {
        Intrinsics.checkParameterIsNotNull(result, (String)"result");
        if (result.getStatus() == RequestStatus.COMPLETED) {
            if (result.getResult() == null) {
                this.setFailed$commons_release(new FlybitsException("There was an issue parsing the response from the server. This is unexpected, please contact support@flybits.com for support."));
            } else {
                PagedResponse<T> pagedResponse = result.getResult();
                Intrinsics.checkExpressionValueIsNotNull(pagedResponse, (String)"result.result");
                ArrayList<T> arrayList = pagedResponse.getItems();
                Intrinsics.checkExpressionValueIsNotNull(arrayList, (String)"result.result.items");
                PagedResponse<T> pagedResponse2 = result.getResult();
                Intrinsics.checkExpressionValueIsNotNull(pagedResponse2, (String)"result.result");
                Pagination pagination = pagedResponse2.getPagination();
                Intrinsics.checkExpressionValueIsNotNull((Object)pagination, (String)"result.result.pagination");
                this.setSuccess$commons_release(arrayList, pagination);
            }
        } else {
            FlybitsException flybitsException = result.getException();
            Intrinsics.checkExpressionValueIsNotNull((Object)flybitsException, (String)"result.exception");
            this.setFailed$commons_release(flybitsException);
        }
    }

    public abstract <K extends QueryParameters> void getMoreRequest(@NotNull K var1, @NotNull PagedResultCallback<T> var2);

    public final boolean setFailed$commons_release(@NotNull FlybitsException e) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        if (this.failed()) {
            if (this.callback != null) {
                Handler handler = this.handler;
                if (handler != null) {
                    handler.post(new Runnable(this, e){
                        final /* synthetic */ PagedResult this$0;
                        final /* synthetic */ FlybitsException $e;

                        public final void run() {
                            this.this$0.getCallback().onException(this.$e);
                        }
                        {
                            this.this$0 = pagedResult;
                            this.$e = flybitsException;
                        }
                    });
                } else {
                    this.callback.onException(e);
                }
            }
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public final void setSuccess$commons_release(@NotNull ArrayList<T> items, @NotNull Pagination pagination) {
        Intrinsics.checkParameterIsNotNull(items, (String)"items");
        Intrinsics.checkParameterIsNotNull((Object)pagination, (String)"pagination");
        this.totalItems = pagination.getTotalRecords();
        this.currentOffset = pagination.getOffset() + (long)items.size();
        if (this.success() && this.callback != null) {
            Handler handler = this.handler;
            if (handler != null) {
                handler.post(new Runnable(this, items, pagination){
                    final /* synthetic */ PagedResult this$0;
                    final /* synthetic */ ArrayList $items;
                    final /* synthetic */ Pagination $pagination;

                    public final void run() {
                        PagedResult.access$postSuccess(this.this$0, this.$items, this.$pagination);
                    }
                    {
                        this.this$0 = pagedResult;
                        this.$items = arrayList;
                        this.$pagination = pagination;
                    }
                });
            } else {
                this.postSuccess(items, pagination);
            }
        }
    }

    private final boolean hasMore() {
        return this.limit < this.totalItems && this.currentOffset < this.totalItems;
    }

    private final void postSuccess(ArrayList<T> items, Pagination pagination) {
        if (this.callback != null) {
            this.callback.onSuccess(items, pagination);
            if (!this.hasMore()) {
                this.callback.onLoadedAllItems();
            }
        }
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @Nullable
    public final PagedResultCallback<T> getCallback() {
        return this.callback;
    }

    @Nullable
    public final Handler getHandler() {
        return this.handler;
    }

    public PagedResult(@NotNull Context context, @NotNull QueryParameters filters, @Nullable PagedResultCallback<T> callback, @Nullable Handler handler, @NotNull ExecutorService service) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)filters, (String)"filters");
        Intrinsics.checkParameterIsNotNull((Object)service, (String)"service");
        super(service, 0L, null, 6, null);
        this.context = context;
        this.filters = filters;
        this.callback = callback;
        this.handler = handler;
        this.currentOffset = this.filters.getOffset();
        this.limit = this.filters.getLimit();
    }

    public /* synthetic */ PagedResult(Context context, QueryParameters queryParameters, PagedResultCallback pagedResultCallback, Handler handler, ExecutorService executorService, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            pagedResultCallback = null;
        }
        if ((n & 8) != 0) {
            handler = null;
        }
        if ((n & 0x10) != 0) {
            ExecutorService executorService2 = Executors.newSingleThreadExecutor();
            Intrinsics.checkExpressionValueIsNotNull((Object)executorService2, (String)"Executors.newSingleThreadExecutor()");
            executorService = executorService2;
        }
        this(context, queryParameters, pagedResultCallback, handler, executorService);
    }

    public static final /* synthetic */ void access$postSuccess(PagedResult $this, ArrayList items, Pagination pagination) {
        $this.postSuccess(items, pagination);
    }
}

