package com.flybits.commons.library.caching;

import android.app.Activity;
import android.content.Context;

import com.flybits.commons.library.models.User;
import com.flybits.internal.db.CommonsDatabase;

import java.util.ArrayList;
import java.util.List;

/**
 * The {@code UserCacheLoader} is responsible for loading cached data associated to a {@link User}.
 * This data is inserted into the local SQLite DB whenever {@link User} data is received from the
 * Flybits server.
 */
public class UserCacheLoader extends FlybitsCacheLoader<User> {

    /**
     * Constructor used to define a {@link UserCacheLoader} class with the Context parameter.
     *
     * @param context The context of the activity that created this object.
     * @deprecated Use {@link #UserCacheLoader(Activity)} as it is more optimized.
     */
    @Deprecated
    public UserCacheLoader(Context context){
        super(context);
    }

    /**
     * Constructor used to define a {@link UserCacheLoader} class with the Activity parameter.
     *
     * @param activity The activity that created this object.
     */
    public UserCacheLoader(Activity activity){
        super(activity);
    }

    @Override
    protected List<User> load(List<String> cachedIds, int limit) {
        List<User> listOfUsers = new ArrayList<>();
        listOfUsers.add(CommonsDatabase.getDatabase(getContext()).userDao().getSingle());
        return listOfUsers;
    }

    @Override
    protected User load(String id) {
        return CommonsDatabase.getDatabase(getContext()).userDao().getSingle();
    }

    /**
     * This get method is used to retrieve the cached data associated to the logged in {@link User}.
     *
     * @param callback The {@link CacheListLoader} callback that loads the cached data.
     * @return This {@link #UserCacheLoader} object.
     */
    public UserCacheLoader get(final CacheObjectLoader<User> callback){
        super.getItem(null, callback);
        return this;
    }
}
