/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.internal.db;

import android.arch.lifecycle.ComputableLiveData;
import android.arch.lifecycle.LiveData;
import android.arch.persistence.db.SupportSQLiteQuery;
import android.arch.persistence.db.SupportSQLiteStatement;
import android.arch.persistence.room.EntityInsertionAdapter;
import android.arch.persistence.room.InvalidationTracker;
import android.arch.persistence.room.RoomDatabase;
import android.arch.persistence.room.RoomSQLiteQuery;
import android.arch.persistence.room.SharedSQLiteStatement;
import android.database.Cursor;
import android.support.annotation.NonNull;
import com.flybits.internal.db.CachingEntryDAO;
import com.flybits.internal.db.models.CachingEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class CachingEntryDAO_Impl
implements CachingEntryDAO {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter __insertionAdapterOfCachingEntry;
    private final SharedSQLiteStatement __preparedStmtOfClear;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAllByCachingKey;

    public CachingEntryDAO_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfCachingEntry = new EntityInsertionAdapter<CachingEntry>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `cachingentry`(`cachingkey`,`contentID`,`sequence`) VALUES (?,?,nullif(?, 0))";
            }

            public void bind(SupportSQLiteStatement stmt, CachingEntry value) {
                if (value.getCachingKey() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getCachingKey());
                }
                if (value.getContentId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getContentId());
                }
                stmt.bindLong(3, (long)value.getSequence());
            }
        };
        this.__preparedStmtOfClear = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "Delete from cachingentry";
                return "Delete from cachingentry";
            }
        };
        this.__preparedStmtOfDeleteAllByCachingKey = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "Delete from cachingentry WHERE cachingkey = ?";
                return "Delete from cachingentry WHERE cachingkey = ?";
            }
        };
    }

    @Override
    public void insert(CachingEntry entry) {
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfCachingEntry.insert((Object)entry);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(List<CachingEntry> entry) {
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfCachingEntry.insert(entry);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void clear() {
        SupportSQLiteStatement _stmt = this.__preparedStmtOfClear.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfClear.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAllByCachingKey(String key) {
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAllByCachingKey.acquire();
        this.__db.beginTransaction();
        try {
            int _argIndex = 1;
            if (key == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindString(_argIndex, key);
            }
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAllByCachingKey.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getIdsByCachingKey(String key) {
        String _sql = "SELECT contentID FROM cachingentry WHERE cachingkey = ? order by sequence ASC";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT contentID FROM cachingentry WHERE cachingkey = ? order by sequence ASC", (int)1);
        int _argIndex = 1;
        if (key == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, key);
        }
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            ArrayList<String> _result = new ArrayList<String>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _item = _cursor.getString(0);
                _result.add(_item);
            }
            ArrayList<String> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getUniqueIdsByCachingKey(String key) {
        String _sql = "SELECT contentId FROM ( SELECT contentID, sequence, cachingkey FROM cachingentry GROUP BY contentID HAVING COUNT(contentID) = 1 ) WHERE cachingkey = ? ORDER BY sequence ASC";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT contentId FROM ( SELECT contentID, sequence, cachingkey FROM cachingentry GROUP BY contentID HAVING COUNT(contentID) = 1 ) WHERE cachingkey = ? ORDER BY sequence ASC", (int)1);
        int _argIndex = 1;
        if (key == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, key);
        }
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            ArrayList<String> _result = new ArrayList<String>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _item = _cursor.getString(0);
                _result.add(_item);
            }
            ArrayList<String> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CachingEntry> getByKey(String key) {
        String _sql = "SELECT * FROM cachingentry WHERE cachingkey = ? order by sequence ASC";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM cachingentry WHERE cachingkey = ? order by sequence ASC", (int)1);
        int _argIndex = 1;
        if (key == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, key);
        }
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            int _cursorIndexOfCachingKey = _cursor.getColumnIndexOrThrow("cachingkey");
            int _cursorIndexOfContentId = _cursor.getColumnIndexOrThrow("contentID");
            int _cursorIndexOfSequence = _cursor.getColumnIndexOrThrow("sequence");
            ArrayList<CachingEntry> _result = new ArrayList<CachingEntry>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                CachingEntry _item = new CachingEntry();
                String _tmpCachingKey = _cursor.getString(_cursorIndexOfCachingKey);
                _item.setCachingKey(_tmpCachingKey);
                String _tmpContentId = _cursor.getString(_cursorIndexOfContentId);
                _item.setContentId(_tmpContentId);
                int _tmpSequence = _cursor.getInt(_cursorIndexOfSequence);
                _item.setSequence(_tmpSequence);
                _result.add(_item);
            }
            ArrayList<CachingEntry> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CachingEntry> getUniqueByKey(String key) {
        String _sql = "SELECT * FROM ( SELECT * FROM cachingentry GROUP BY contentID HAVING COUNT(contentID) = 1 ) WHERE cachingkey = ? ORDER BY sequence ASC";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM ( SELECT * FROM cachingentry GROUP BY contentID HAVING COUNT(contentID) = 1 ) WHERE cachingkey = ? ORDER BY sequence ASC", (int)1);
        int _argIndex = 1;
        if (key == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, key);
        }
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            int _cursorIndexOfCachingKey = _cursor.getColumnIndexOrThrow("cachingkey");
            int _cursorIndexOfContentId = _cursor.getColumnIndexOrThrow("contentID");
            int _cursorIndexOfSequence = _cursor.getColumnIndexOrThrow("sequence");
            ArrayList<CachingEntry> _result = new ArrayList<CachingEntry>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                CachingEntry _item = new CachingEntry();
                String _tmpCachingKey = _cursor.getString(_cursorIndexOfCachingKey);
                _item.setCachingKey(_tmpCachingKey);
                String _tmpContentId = _cursor.getString(_cursorIndexOfContentId);
                _item.setContentId(_tmpContentId);
                int _tmpSequence = _cursor.getInt(_cursorIndexOfSequence);
                _item.setSequence(_tmpSequence);
                _result.add(_item);
            }
            ArrayList<CachingEntry> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public LiveData<List<CachingEntry>> getLive(String key) {
        String _sql = "SELECT * FROM cachingentry WHERE cachingkey = ? order by sequence ASC";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM cachingentry WHERE cachingkey = ? order by sequence ASC", (int)1);
        int _argIndex = 1;
        if (key == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, key);
        }
        return new ComputableLiveData<List<CachingEntry>>(){
            private InvalidationTracker.Observer _observer;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected List<CachingEntry> compute() {
                if (this._observer == null) {
                    this._observer = new InvalidationTracker.Observer("cachingentry", new String[0]){

                        public void onInvalidated(@NonNull Set<String> tables) {
                            this.invalidate();
                        }
                    };
                    CachingEntryDAO_Impl.this.__db.getInvalidationTracker().addWeakObserver(this._observer);
                }
                try (Cursor _cursor = CachingEntryDAO_Impl.this.__db.query((SupportSQLiteQuery)_statement);){
                    int _cursorIndexOfCachingKey = _cursor.getColumnIndexOrThrow("cachingkey");
                    int _cursorIndexOfContentId = _cursor.getColumnIndexOrThrow("contentID");
                    int _cursorIndexOfSequence = _cursor.getColumnIndexOrThrow("sequence");
                    ArrayList<CachingEntry> _result = new ArrayList<CachingEntry>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        CachingEntry _item = new CachingEntry();
                        String _tmpCachingKey = _cursor.getString(_cursorIndexOfCachingKey);
                        _item.setCachingKey(_tmpCachingKey);
                        String _tmpContentId = _cursor.getString(_cursorIndexOfContentId);
                        _item.setContentId(_tmpContentId);
                        int _tmpSequence = _cursor.getInt(_cursorIndexOfSequence);
                        _item.setSequence(_tmpSequence);
                        _result.add(_item);
                    }
                    ArrayList<CachingEntry> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        }.getLiveData();
    }
}

