/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.deserializations;

import com.flybits.commons.library.deserializations.IDeserializer;
import com.flybits.commons.library.logging.Logger;
import com.flybits.commons.library.models.internal.PagedResponse;
import com.flybits.commons.library.models.internal.Pagination;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DeserializePagedResponse<T>
extends IDeserializer<PagedResponse<T>> {
    private IDeserializer deserializer;

    public DeserializePagedResponse(IDeserializer deserializer) {
        this.deserializer = deserializer;
    }

    @Override
    public String toJson(PagedResponse<T> obj) {
        JSONArray object = new JSONArray();
        return object.toString();
    }

    @Override
    public PagedResponse<T> fromJson(JSONObject jObj) {
        try {
            Pagination pagination = null;
            if (!jObj.isNull("pagination")) {
                JSONObject paginationObj = jObj.getJSONObject("pagination");
                if (!(paginationObj.isNull("limit") || paginationObj.isNull("totalRecords") || paginationObj.isNull("offset"))) {
                    int limit = paginationObj.getInt("limit");
                    int offset = paginationObj.getInt("offset");
                    int totalRecords = paginationObj.getInt("totalRecords");
                    pagination = new Pagination(limit, offset, totalRecords);
                } else {
                    return null;
                }
            }
            if (!jObj.isNull("data")) {
                ArrayList items = new ArrayList();
                JSONArray dataArray = jObj.getJSONArray("data");
                for (int i = 0; i < dataArray.length(); ++i) {
                    JSONObject elementObj = dataArray.getJSONObject(i);
                    Object deserializedItem = this.deserializer.fromJson(elementObj);
                    if (deserializedItem == null) continue;
                    items.add(deserializedItem);
                }
                return new PagedResponse(items, pagination);
            }
        }
        catch (JSONException e) {
            Logger.exception("DeserializePagedResponse.fromJson", (Exception)((Object)e));
        }
        return null;
    }

    @Override
    public PagedResponse<T> fromJson(JSONArray jsonObject) {
        return null;
    }
}

