/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.api.idps;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.flybits.commons.library.SharedElementsFactory;
import com.flybits.commons.library.api.idps.IDP;
import com.flybits.commons.library.api.results.BasicResult;
import com.flybits.commons.library.api.results.callbacks.BasicResultCallback;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.http.HttpDefaultClass;
import com.flybits.commons.library.models.internal.Result;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONException;
import org.json.JSONObject;

public class FlybitsIDP
extends IDP {
    private static final String AUTHENTICATE_ENDPOINT = "/authenticate";
    private static final String RESET_PASSWORD_ENDPOINT = "/sso/auth/sendResetPasswordEmail";
    private static final String SEND_CONFIRMATION = "/sso/auth/sendConfirmEmail";
    private String firstName;
    private String lastName;
    private String email;
    private String password;
    private boolean sendConfirmationEmail;
    public static final Parcelable.Creator<FlybitsIDP> CREATOR = new Parcelable.Creator<FlybitsIDP>(){

        public FlybitsIDP createFromParcel(Parcel in) {
            return new FlybitsIDP(in);
        }

        public FlybitsIDP[] newArray(int size) {
            return new FlybitsIDP[size];
        }
    };

    private FlybitsIDP(Parcel in) {
        super(in);
        this.firstName = in.readString();
        this.lastName = in.readString();
        this.email = in.readString();
        this.password = in.readString();
    }

    public FlybitsIDP(@NonNull String email, @NonNull String password, String firstName, String lastName, boolean sendConfirmationEmail) {
        this(email, password, firstName, lastName);
        this.sendConfirmationEmail = sendConfirmationEmail;
    }

    public FlybitsIDP(@NonNull String email, @NonNull String password, String firstName, String lastName) {
        this(email, password);
        this.firstName = firstName;
        this.lastName = lastName;
    }

    public FlybitsIDP(@NonNull String email, @NonNull String password) {
        this();
        this.email = email;
        this.password = password;
    }

    private FlybitsIDP() {
        super("flybits");
    }

    public String getEmail() {
        return this.email;
    }

    public boolean isSendConfirmationEmail() {
        return this.sendConfirmationEmail;
    }

    @Override
    public String getAuthenticationEndPoint() {
        return AUTHENTICATE_ENDPOINT;
    }

    @Override
    public JSONObject getBody() {
        JSONObject bodyObject = new JSONObject();
        try {
            bodyObject.put("email", (Object)this.email);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            bodyObject.put("password", (Object)this.password);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        if (this.firstName != null && this.lastName != null) {
            try {
                bodyObject.put("firstName", (Object)this.firstName);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            try {
                bodyObject.put("lastName", (Object)this.lastName);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return bodyObject;
    }

    public static BasicResult requestNewPassword(final @NonNull Context context, final @NonNull String email, @NonNull BasicResultCallback callback, @NonNull Handler handler) {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        final BasicResult request = new BasicResult(callback, handler, executorService);
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                String body2 = "{\"email\" : \"" + email + "\"}";
                String url = SharedElementsFactory.INSTANCE.get(context).getGatewayURL() + FlybitsIDP.RESET_PASSWORD_ENDPOINT;
                try {
                    Result result = new HttpDefaultClass.Builder(context, false, url).post(body2).getResponse();
                    request.setResult(result);
                }
                catch (Exception e) {
                    if (e instanceof FlybitsException) {
                        request.setFailed((FlybitsException)e);
                    }
                    request.setFailed(new FlybitsException(e));
                }
            }
        });
        return request;
    }

    public static BasicResult requestNewPassword(@NonNull Context context, @NonNull String email, @NonNull BasicResultCallback callback) {
        return FlybitsIDP.requestNewPassword(context, email, callback, new Handler(Looper.getMainLooper()));
    }

    public static BasicResult sendConfirmationEmail(final @NonNull Context context, final @NonNull String email, BasicResultCallback callback) {
        Handler handler = new Handler(Looper.getMainLooper());
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        final BasicResult request = new BasicResult(callback, handler, executorService);
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                String body2 = "{\"email\" : \"" + email + "\"}";
                String url = SharedElementsFactory.INSTANCE.get(context).getGatewayURL() + FlybitsIDP.SEND_CONFIRMATION;
                try {
                    Result result = new HttpDefaultClass.Builder(context, false, url).post(body2).getResponse();
                    request.setResult(result);
                }
                catch (Exception e) {
                    if (e instanceof FlybitsException) {
                        request.setFailed((FlybitsException)e);
                    }
                    request.setFailed(new FlybitsException(e));
                }
            }
        });
        return request;
    }

    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        super.writeToParcel(out, flags);
        out.writeString(this.firstName);
        out.writeString(this.lastName);
        out.writeString(this.email);
        out.writeString(this.password);
    }
}

