package com.flybits.commons.library.logging

/**
 * Logger is an internal class that used to log information to the logcat.
 */
object Logger {

    internal const val DEFAULT_TAG = "FlybitsSDK"

    /**
     * Retrieve the [Displayer] that displays information within the logcat.
     *
     * @return The [Displayer] that displays the information in the logcat.
     */
    @JvmStatic
    internal val displayer = Displayer(DEFAULT_TAG)

    /**
     * Set the Tag that the logcat information is set under.
     *
     * @param tag The tag that is used to display information within the logcat under.
     * @return The [Displayer] that displays the information in the logcat.
     */
    @JvmStatic
    fun setTag(tag: String): Displayer {
        return displayer.changeTag(tag)
    }

    /**
     * Creates a log statement in the logcat that displays information used to debug the Flybits
     * SDK.
     *
     * @param msg - The message to be displayed in the logcat.
     */
    @JvmStatic
    fun d(msg: String) {
        displayer.changeTag(DEFAULT_TAG)
        displayer.d(msg)
    }

    /**
     * Creates a log statement in the logcat that displays an error.
     *
     * @param msg - The message to be displayed in the logcat.
     */
    @JvmStatic
    fun e(msg: String) {
        displayer.changeTag(DEFAULT_TAG)
        displayer.e(msg)
    }

    /**
     * Creates a log statement in the logcat that displays some information.
     *
     * @param msg - The message to be displayed in the logcat.
     */
    @JvmStatic
    fun i(msg: String) {
        displayer.changeTag(DEFAULT_TAG)
        displayer.i(msg)
    }

    /**
     * Creates a log statement in the logcat that displays a warning.
     *
     * @param msg - The message to be displayed in the logcat.
     */
    @JvmStatic
    fun w(msg: String) {
        displayer.changeTag(DEFAULT_TAG)
        displayer.w(msg)
    }

    /**
     * Creates a log statement in the logcat that will display an exception's information and print
     * the stack trace. This is only available is the user has set activated logging when they
     * initiate Flybits for the first time.
     *
     * @param sdkMethod The name of the method where the error was caused.
     * @param e - The exception to display information about.
     */
    @JvmStatic
    fun exception(sdkMethod: String, e: Exception) {

        //caughtFailure(sdkMethod, e.getMessage(), null);

        displayer.changeTag(DEFAULT_TAG)
        displayer.exception(e)
    }
}
