package com.flybits.commons.library.deserializations;

import com.flybits.commons.library.logging.Logger;
import com.flybits.commons.library.models.User;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DeserializeLogin extends IDeserializer<User>{

    @Override
    public String toJson(User obj) {

        JSONObject object = new JSONObject();

        if (obj.getId() != null){
            try{
                object.put("id", obj.getId());
            }catch(JSONException ex){}
        }

        if (obj.getEmail() != null){
            try{
                object.put("email", obj.getEmail());
            }catch(JSONException ex){}
        }

        if (obj.getDeviceID() != null){
            try{
                object.put("currentDeviceId", obj.getDeviceID());
            }catch(JSONException ex){}
        }

        if (obj.getFirstName() != null){
            try{
                object.put("firstName", obj.getFirstName());
            }catch(JSONException ex){}
        }

        if (obj.getLastName() != null){
            try{
                object.put("lastName", obj.getLastName());
            }catch(JSONException ex){}
        }
        try {
            object.put("isConfirmed", obj.isVerified());
        }catch (JSONException ex){}

        try {
            object.put(User.FIELD_IS_OPTED_IN, obj.isOptedIn());
        } catch (JSONException e) {
        }

        return object.toString();
    }

    @Override
    public User fromJson(JSONObject jObj) {
        try {
            if (!jObj.isNull("id") && !jObj.isNull("email") && !jObj.isNull("currentDeviceId")) {

                String id = jObj.getString("id");
                String email = jObj.getString("email");
                String deviceID = jObj.getString("currentDeviceId");

                User user = new User(id, email, deviceID);
                if (!jObj.isNull("firstName") && !jObj.isNull("lastName")) {
                    user.setName(jObj.getString("firstName"), jObj.getString("lastName"));
                }
                if (!jObj.isNull("isConfirmed")) {
                    user.setIsVerified(jObj.getBoolean("isConfirmed"));
                }
                if (jObj.has(User.FIELD_IS_OPTED_IN)){
                    user.setOptedIn(jObj.getBoolean(User.FIELD_IS_OPTED_IN));
                } else {
                    user.setOptedIn(true);
                }

                return user;
            }
        } catch (JSONException e) {
            Logger.exception("DeserializeLogin.fromJson", e);
        }
        return null;
    }

    @Override
    public User fromJson(JSONArray jsonObject) {
        return null;
    }
}
