/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library;

import com.flybits.commons.library.UniqueDeviceIdGenerator;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/flybits/commons/library/DefaultUniqueDeviceIdGenerator;", "Lcom/flybits/commons/library/UniqueDeviceIdGenerator;", "advertisingIdClient", "Lcom/google/android/gms/ads/identifier/AdvertisingIdClient;", "(Lcom/google/android/gms/ads/identifier/AdvertisingIdClient;)V", "generateUniqueDeviceId", "", "commons_release"})
public final class DefaultUniqueDeviceIdGenerator
implements UniqueDeviceIdGenerator {
    private final AdvertisingIdClient advertisingIdClient;

    @Override
    @NotNull
    public String generateUniqueDeviceId() {
        try {
            AdvertisingIdClient.Info info = this.advertisingIdClient.getInfo();
            Intrinsics.checkExpressionValueIsNotNull((Object)info, (String)"advertisingIdClient.info");
            String string = info.getId();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"advertisingIdClient.info.id");
            return string;
        }
        catch (IOException ioException) {
            throw (Throwable)new FlybitsException("Error accessing Google Play Services");
        }
        catch (IllegalStateException illegalStateException) {
            throw (Throwable)new FlybitsException("Accessing Google Play Services Unique Id from main thread");
        }
        catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
            throw (Throwable)new FlybitsException("Google Play Services is not installed on device");
        }
        catch (GooglePlayServicesRepairableException googlePlayServicesRepairableException) {
            throw (Throwable)new FlybitsException("Google Play Services not installed, not updated or not enabled");
        }
    }

    public DefaultUniqueDeviceIdGenerator(@NotNull AdvertisingIdClient advertisingIdClient) {
        Intrinsics.checkParameterIsNotNull((Object)advertisingIdClient, (String)"advertisingIdClient");
        this.advertisingIdClient = advertisingIdClient;
    }
}

