package com.flybits.commons.library

import com.flybits.commons.library.exceptions.FlybitsException
import com.google.android.gms.ads.identifier.AdvertisingIdClient
import com.google.android.gms.common.GooglePlayServicesNotAvailableException
import com.google.android.gms.common.GooglePlayServicesRepairableException
import java.io.IOException
import java.lang.IllegalStateException

/**
 * Default implementation for generating unique physical device id
 * Using Google's Advertising Id as the unique id
 * @param advertisingIdClient client to fetch the advertising Id
 */
internal class DefaultUniqueDeviceIdGenerator(private val advertisingIdClient: AdvertisingIdClient) : UniqueDeviceIdGenerator {

    override fun generateUniqueDeviceId(): String {

        try {
            return advertisingIdClient.info.id
        } catch(ioException : IOException) {
            throw FlybitsException("Error accessing Google Play Services")
        } catch (illegalStateException : IllegalStateException) {
            throw FlybitsException("Accessing Google Play Services Unique Id from main thread")
        } catch (googlePlayServicesNotAvailableException : GooglePlayServicesNotAvailableException) {
            throw FlybitsException("Google Play Services is not installed on device")
        } catch (googlePlayServicesRepairableException : GooglePlayServicesRepairableException) {
            throw FlybitsException("Google Play Services not installed, not updated or not enabled")
        }
    }

}