/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.analytics;

import android.support.annotation.NonNull;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class Properties {
    private Map<String, Object> propertyMap = new LinkedHashMap<String, Object>();

    public Properties() {
    }

    public Properties(@NonNull Map<String, Object> map) {
        this.propertyMap = map;
    }

    public Properties(@NonNull String json) throws JSONException {
        JSONObject rootObj = new JSONObject(json);
        Iterator iter = rootObj.keys();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            this.propertyMap.put(key, rootObj.get(key));
        }
    }

    public Properties addProperty(@NonNull String name, int value) {
        this.propertyMap.put(name, value);
        return this;
    }

    public Properties addProperty(@NonNull String name, long value) {
        this.propertyMap.put(name, value);
        return this;
    }

    public Properties addProperty(String name, float value) {
        this.propertyMap.put(name, Float.valueOf(value));
        return this;
    }

    public Properties addProperty(String name, double value) {
        this.propertyMap.put(name, value);
        return this;
    }

    public Properties addProperty(@NonNull String name, String value) {
        this.propertyMap.put(name, value);
        return this;
    }

    public Map<String, Object> getMap() {
        return this.propertyMap;
    }

    public String toJSON() throws JSONException {
        JSONObject rootObj = new JSONObject();
        for (Map.Entry<String, Object> entry : this.propertyMap.entrySet()) {
            rootObj.put(entry.getKey(), entry.getValue());
        }
        return rootObj.toString();
    }
}

