package com.flybits.commons.library.analytics.services;

import android.content.SharedPreferences;

import com.flybits.commons.library.SharedElements;
import com.flybits.commons.library.analytics.AnalyticsBundle;
import com.flybits.commons.library.analytics.AnalyticsOptions;
import com.flybits.commons.library.analytics.storage.MemoryStorage;
import com.flybits.commons.library.analytics.storage.QueueStorage;
import com.flybits.commons.library.analytics.storage.sql.SqliteStorage;
import com.flybits.commons.library.api.Analytics;
import com.flybits.commons.library.logging.Logger;
import com.google.android.gms.gcm.GcmNetworkManager;
import com.google.android.gms.gcm.GcmTaskService;
import com.google.android.gms.gcm.TaskParams;

import java.util.Locale;

import static com.flybits.commons.library.api.Analytics.PREFS_STORAGETYPE;

/**
 * Created by Filip on 11/28/2016.
 */
public class AnalyticsUploadService extends GcmTaskService {

    public final static String _TAG = "Analytics:Service";
    
    @Override
    public int onRunTask(TaskParams taskParams) {
        Logger.setTag(_TAG).d("Analytics Upload service calling flush...");

        //Load the proper QueueStorage
        SharedPreferences preferences = SharedElements.getPreferences(getBaseContext());
        String queueStorageType = preferences.getString(PREFS_STORAGETYPE, null);

        if (queueStorageType == null)
            return GcmNetworkManager.RESULT_SUCCESS;
        QueueStorage queueStorage = null;

        AnalyticsOptions.StorageType type = AnalyticsOptions.StorageType.fromValue(queueStorageType);

        switch (type) {
            case MEMORY_ONLY:
                queueStorage = new MemoryStorage();
                break;
            case BINARY:
                queueStorage = new MemoryStorage();
                break;
            case SQLITE_DB:
                queueStorage = new SqliteStorage(getBaseContext());
                break;
            default:
                queueStorage = new MemoryStorage();
        }

        //Begin upload
        synchronized (queueStorage)
        {
            AnalyticsBundle[] bundles = queueStorage.getAll();

            if (bundles.length == 0) {
                Logger.setTag(_TAG).d(String.format("No events to flush", bundles.length));
                return GcmNetworkManager.RESULT_SUCCESS;
            }

            Logger.setTag(_TAG).d(String.format(Locale.getDefault(),"Starting flush of %d events", bundles.length));

            Analytics.flushEvents(getBaseContext());

        }

        return GcmNetworkManager.RESULT_SUCCESS;

    }

}
