/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.api.results;

import android.content.Context;
import android.os.Handler;
import android.support.annotation.NonNull;
import com.flybits.commons.library.api.results.FlybitsResult;
import com.flybits.commons.library.api.results.callbacks.PagedResultCallback;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.http.RequestStatus;
import com.flybits.commons.library.models.internal.PagedResponse;
import com.flybits.commons.library.models.internal.Pagination;
import com.flybits.commons.library.models.internal.QueryParameters;
import com.flybits.commons.library.models.internal.Result;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;

public abstract class PagedResult<T>
extends FlybitsResult {
    private long currentOffset;
    private long totalItems;
    private long limit;
    private PagedResultCallback<T> callback;
    private QueryParameters parameters;
    private Handler handler;
    private boolean isBackwardsCompat;

    protected PagedResult(@NonNull Context context, PagedResultCallback<T> callback) {
        super(context);
        this.callback = callback;
        this.limit = 0L;
        this.currentOffset = 0L;
        this.totalItems = 0L;
    }

    protected PagedResult(@NonNull Context context, PagedResultCallback<T> callback, @NonNull ExecutorService service) {
        super(context, service);
        this.limit = 0L;
        this.currentOffset = 0L;
        this.totalItems = 0L;
        this.callback = callback;
    }

    @Deprecated
    protected PagedResult(@NonNull Context context, @NonNull QueryParameters parameters, PagedResultCallback<T> callback, @NonNull ExecutorService service) {
        this(context, callback, service);
        this.limit = parameters.getLimit();
        this.currentOffset = parameters.getOffset();
        this.totalItems = 0L;
    }

    protected PagedResult(@NonNull Context context, @NonNull QueryParameters parameters, PagedResultCallback<T> callback, @NonNull ExecutorService service, @NonNull Handler handler) {
        this(context, callback, service);
        this.limit = parameters.getLimit();
        this.currentOffset = parameters.getOffset();
        this.totalItems = 0L;
        this.isBackwardsCompat = true;
        this.handler = handler;
    }

    public PagedResult getMore(final PagedResultCallback<T> callback) {
        if (this.hasMore()) {
            this.parameters.setPaging(this.limit, this.currentOffset);
            return this.getMore(this.getContext(), this.parameters, callback);
        }
        if (callback != null) {
            if (this.isBackwardsCompat && this.handler != null) {
                this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        callback.onLoadedAllItems();
                    }
                });
            } else if (!this.isBackwardsCompat) {
                callback.onLoadedAllItems();
            }
        }
        return this;
    }

    public QueryParameters getParameters() {
        return this.parameters;
    }

    boolean hasMore() {
        return this.limit < this.totalItems && this.currentOffset < this.totalItems;
    }

    @Override
    public boolean setFailed(final FlybitsException e) {
        if (super.setFailed(e)) {
            if (this.callback != null) {
                if (this.isBackwardsCompat && this.handler != null) {
                    this.handler.post(new Runnable(){

                        @Override
                        public void run() {
                            PagedResult.this.callback.onException(e);
                        }
                    });
                } else if (!this.isBackwardsCompat) {
                    this.callback.onException(e);
                }
            }
            return true;
        }
        return false;
    }

    protected void setSuccess(QueryParameters parameters, final @NonNull ArrayList<T> items, @NonNull Pagination pagination) {
        this.parameters = parameters;
        this.limit = pagination.getLimit();
        this.totalItems = pagination.getTotalRecords();
        long l = this.currentOffset = items != null ? pagination.getOffset() + (long)items.size() : 0L;
        if (this.setSuccess() && items != null && this.callback != null) {
            if (this.isBackwardsCompat && this.handler != null) {
                this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        PagedResult.this.callback.onSuccess(items);
                        if (!PagedResult.this.hasMore()) {
                            PagedResult.this.callback.onLoadedAllItems();
                        }
                    }
                });
            } else if (!this.isBackwardsCompat) {
                this.callback.onSuccess(items);
                if (!this.hasMore()) {
                    this.callback.onLoadedAllItems();
                }
            }
        }
    }

    public void setResult(@NonNull Result<PagedResponse<T>> result, QueryParameters params) {
        if (result.getStatus() == RequestStatus.COMPLETED && result.getResult() != null) {
            this.setSuccess(params, result.getResult().getItems(), result.getResult().getPagination());
        } else {
            this.setFailed(result.getException());
        }
    }

    protected abstract <K extends QueryParameters> PagedResult getMore(Context var1, K var2, PagedResultCallback<T> var3);
}

