/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.utils;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.ArrayList;

public class CNF {
    private ArrayList<ArrayList<String>> items;

    CNF(Builder builder) {
        if (builder.items != null) {
            this.items = builder.items;
        }
    }

    @Nullable
    public String toString() {
        StringBuilder labelsBuilder = new StringBuilder();
        if (this.items != null && this.items.size() > 0) {
            boolean hasMoreThan1Entry;
            boolean bl = hasMoreThan1Entry = this.items.size() > 1;
            if (hasMoreThan1Entry) {
                labelsBuilder.append("(");
            }
            for (int index = 0; index < this.items.size(); ++index) {
                labelsBuilder.append(this.parseCNF(this.items.get(index)));
                if (index >= this.items.size() - 1) continue;
                labelsBuilder.append(",");
            }
            if (hasMoreThan1Entry) {
                labelsBuilder.append(")");
            }
        }
        if (labelsBuilder.length() == 0) {
            return null;
        }
        return labelsBuilder.toString();
    }

    private String parseCNF(ArrayList<String> listOfItems) {
        StringBuilder labelsBuilder = new StringBuilder("(");
        if (listOfItems.size() == 1) {
            labelsBuilder.append(listOfItems.get(0));
            labelsBuilder.append(")");
            return labelsBuilder.toString();
        }
        for (int index2 = 0; index2 < listOfItems.size(); ++index2) {
            labelsBuilder.append(listOfItems.get(index2));
            if (index2 == listOfItems.size() - 1) continue;
            labelsBuilder.append(";");
        }
        labelsBuilder.append(")");
        return labelsBuilder.toString();
    }

    public static class Builder {
        private ArrayList<ArrayList<String>> items;

        private void initialize() {
            this.items = new ArrayList();
        }

        public Builder(@NonNull String item) {
            this.initialize();
            ArrayList<String> listOfItems = new ArrayList<String>();
            listOfItems.add(item);
            this.items.add(listOfItems);
        }

        public Builder(@NonNull ArrayList<String> newItems, @NonNull BooleanOperator operator) {
            this.initialize();
            switch (operator) {
                case AND: {
                    for (String item : newItems) {
                        ArrayList<String> listOfItems = new ArrayList<String>();
                        listOfItems.add(item);
                        this.items.add(listOfItems);
                    }
                    break;
                }
                case OR: {
                    this.items.add(newItems);
                }
            }
        }

        public Builder and(@NonNull String topic) {
            ArrayList<String> newTag = new ArrayList<String>();
            newTag.add(topic);
            this.items.add(newTag);
            return this;
        }

        public Builder and(@NonNull ArrayList<String> topics, @NonNull BooleanOperator operator) {
            switch (operator) {
                case AND: {
                    for (String item : topics) {
                        this.and(item);
                    }
                    break;
                }
                case OR: {
                    this.items.add(topics);
                }
            }
            return this;
        }

        public Builder or(@NonNull String topic) {
            if (this.items.size() < 1) {
                this.and(topic);
            } else {
                for (ArrayList<String> listOfTagIds : this.items) {
                    listOfTagIds.add(topic);
                }
            }
            return this;
        }

        public Builder or(@NonNull ArrayList<String> topics, BooleanOperator operator) {
            if (this.items.size() < 1) {
                this.and(topics, operator);
            } else {
                switch (operator) {
                    case AND: {
                        ArrayList temp = new ArrayList();
                        for (ArrayList<String> tempId : this.items) {
                            ArrayList<String> tempString = new ArrayList<String>();
                            tempString.addAll(tempId);
                            temp.add(tempString);
                        }
                        for (int index = 0; index < temp.size(); ++index) {
                            for (int index2 = 1; index2 < topics.size(); ++index2) {
                                if (!((ArrayList)temp.get(index)).contains(topics.get(index2))) {
                                    ((ArrayList)temp.get(index)).add(topics.get(index2));
                                }
                                if (this.items.contains(temp.get(index))) continue;
                                this.items.add((ArrayList<String>)temp.get(index));
                            }
                            if (this.items.get(index).contains(topics.get(0))) continue;
                            this.items.get(index).add(topics.get(0));
                        }
                        break;
                    }
                    case OR: {
                        for (ArrayList<String> listOfTagIds : this.items) {
                            for (String item : topics) {
                                if (listOfTagIds.contains(item)) continue;
                                listOfTagIds.add(item);
                            }
                        }
                        break;
                    }
                }
            }
            return this;
        }

        public CNF build() {
            return new CNF(this);
        }
    }

    public static enum BooleanOperator {
        OR,
        AND;

    }
}

