/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.analytics;

import android.content.Context;
import android.support.annotation.NonNull;
import com.flybits.commons.library.analytics.UploadChannel;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;

public class AnalyticsOptions {
    private Context context;
    private String customDeviceId;
    private StorageType storageType;
    private long timeForDataFlush = -1L;
    private long dataFlushTimeFlex = -1L;

    private AnalyticsOptions(Builder builder) {
        this.storageType = builder.storageType;
        this.timeForDataFlush = builder.timeForDataFlush;
        this.dataFlushTimeFlex = builder.dataFlushTimeFlex;
        this.context = builder.context;
        this.customDeviceId = builder.customDeviceId;
    }

    public StorageType getStorageType() {
        return this.storageType;
    }

    public long getDataFlushTime() {
        return this.timeForDataFlush;
    }

    public long getDataFlushTimeFlex() {
        return this.dataFlushTimeFlex;
    }

    public String getCustomDeviceId() {
        return this.customDeviceId;
    }

    public Context getContext() {
        return this.context;
    }

    public static class Builder {
        private String customDeviceId;
        private StorageType storageType;
        private long timeForDataFlush = -1L;
        private long dataFlushTimeFlex = -1L;
        private Context context;
        private ArrayList<Class<? extends UploadChannel>> customUploadChannels;

        public Builder(@NonNull Context context) {
            this.context = context;
            this.storageType = StorageType.SQLITE_DB;
            this.customUploadChannels = null;
            this.customDeviceId = null;
        }

        public AnalyticsOptions build() {
            return new AnalyticsOptions(this);
        }

        public Builder setStorageType(@NonNull StorageType type) {
            this.storageType = type;
            return this;
        }

        public Builder setUploadServiceTime(long timeUpdate, long timeFlex, @NonNull TimeUnit metric) {
            this.timeForDataFlush = metric.toSeconds(timeUpdate);
            this.dataFlushTimeFlex = metric.toSeconds(timeFlex);
            if (this.timeForDataFlush < 60L) {
                this.timeForDataFlush = 60L;
            }
            if (this.dataFlushTimeFlex < 60L) {
                this.dataFlushTimeFlex = 60L;
            }
            return this;
        }

        public Builder setCustomDeviceId(String id) {
            this.customDeviceId = id;
            return this;
        }
    }

    public static enum StorageType {
        SQLITE_DB(0, "sqlite_db"),
        BINARY(1, "binary"),
        MEMORY_ONLY(2, "memory");

        private final int key;
        private final String value;

        private StorageType(int key, String value) {
            this.key = key;
            this.value = value;
        }

        public int getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public static StorageType fromValue(String value) {
            for (StorageType type : StorageType.values()) {
                if (!type.getValue().equalsIgnoreCase(value)) continue;
                return type;
            }
            return MEMORY_ONLY;
        }
    }
}

