package com.flybits.commons.library.deserializations;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public abstract class IDeserializer<T> {

    public abstract String toJson(T obj);

    public T fromJson(String json){
        try {
            Object jsonObject = new JSONTokener(json).nextValue();
            if (jsonObject instanceof JSONObject){
                JSONObject jObject  = new JSONObject(json);
                return fromJson(jObject);
            }else if (jsonObject instanceof JSONArray){
                JSONArray jObject  = new JSONArray(json);
                return fromJson(jObject);
            }
        }catch (JSONException | NullPointerException e){}
        return null;
    }

    public abstract T fromJson(JSONObject jsonObject);

    public abstract T fromJson(JSONArray jsonObject);
}
