/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.models.internal;

import android.support.annotation.NonNull;
import com.flybits.commons.library.models.internal.OrderBy;
import com.flybits.commons.library.models.internal.QueryParameters;
import com.flybits.commons.library.models.internal.SortByEnumeratable;
import com.flybits.commons.library.utils.CNF;

public class QueryBuilder<T extends QueryBuilder> {
    public long limit;
    public long offset;
    public String labelsQuery;
    public OrderBy orderBy;
    public SortByEnumeratable sortBy;
    public String cachingKey;
    public int cachingLimit;

    public QueryBuilder() {
        this.limit = 0L;
        this.offset = -1L;
        this.cachingLimit = 10;
    }

    public QueryBuilder(QueryParameters parameters) {
        this.limit = parameters.getLimit();
        this.offset = parameters.getOffset();
        this.orderBy = parameters.getOrderBy();
        this.sortBy = parameters.getSortBy();
        this.cachingKey = parameters.getCachingKey();
        this.cachingLimit = parameters.getCachingLimit();
        this.labelsQuery = parameters.getLabels();
    }

    protected T setCaching(@NonNull String cachingKey, int limit) {
        this.cachingKey = cachingKey;
        this.cachingLimit = limit;
        return (T)this;
    }

    public T setLabels(String label) {
        if (label != null) {
            CNF cnf = new CNF.Builder(label).build();
            this.labelsQuery = cnf.toString();
        }
        return (T)this;
    }

    public T setLabels(CNF cnf) {
        if (cnf != null) {
            this.labelsQuery = cnf.toString();
        }
        return (T)this;
    }

    public T setPaging(long limit, long offset) {
        this.limit = limit;
        this.offset = offset;
        return (T)this;
    }

    protected T setSorting(@NonNull SortByEnumeratable sort, @NonNull OrderBy order) {
        this.sortBy = sort;
        this.orderBy = order;
        return (T)this;
    }
}

