/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.analytics.services;

import android.content.SharedPreferences;
import com.flybits.commons.library.SharedElements;
import com.flybits.commons.library.analytics.AnalyticsBundle;
import com.flybits.commons.library.analytics.AnalyticsOptions;
import com.flybits.commons.library.analytics.storage.MemoryStorage;
import com.flybits.commons.library.analytics.storage.QueueStorage;
import com.flybits.commons.library.analytics.storage.sql.SqliteStorage;
import com.flybits.commons.library.api.Analytics;
import com.flybits.commons.library.logging.Logger;
import com.google.android.gms.gcm.GcmTaskService;
import com.google.android.gms.gcm.TaskParams;
import java.util.Locale;

public class AnalyticsUploadService
extends GcmTaskService {
    public static final String _TAG = "Analytics:Service";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int onRunTask(TaskParams taskParams) {
        Logger.setTag(_TAG).d("Analytics Upload service calling flush...");
        SharedPreferences preferences = SharedElements.getPreferences(this.getBaseContext());
        String queueStorageType = preferences.getString("fbanalytics_storagetype", null);
        if (queueStorageType == null) {
            return 0;
        }
        QueueStorage queueStorage = null;
        AnalyticsOptions.StorageType type = AnalyticsOptions.StorageType.fromValue(queueStorageType);
        switch (type) {
            case MEMORY_ONLY: {
                queueStorage = new MemoryStorage();
                break;
            }
            case BINARY: {
                queueStorage = new MemoryStorage();
                break;
            }
            case SQLITE_DB: {
                queueStorage = new SqliteStorage(this.getBaseContext());
                break;
            }
            default: {
                queueStorage = new MemoryStorage();
            }
        }
        MemoryStorage memoryStorage = queueStorage;
        synchronized (memoryStorage) {
            AnalyticsBundle[] bundles = queueStorage.getAll();
            if (bundles.length == 0) {
                Logger.setTag(_TAG).d(String.format("No events to flush", bundles.length));
                return 0;
            }
            Logger.setTag(_TAG).d(String.format(Locale.getDefault(), "Starting flush of %d events", bundles.length));
            Analytics.flushEvents(this.getBaseContext());
        }
        return 0;
    }
}

