/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.api.results;

import android.content.Context;
import android.os.Handler;
import android.support.annotation.NonNull;
import com.flybits.commons.library.api.results.FlybitsResult;
import com.flybits.commons.library.api.results.QueryStatus;
import com.flybits.commons.library.api.results.callbacks.ObjectResultCallback;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.http.RequestStatus;
import com.flybits.commons.library.models.internal.Result;
import java.util.concurrent.ExecutorService;

public class ObjectResult<T>
extends FlybitsResult {
    private T object;
    private ObjectResultCallback<T> callback;
    private Handler handler;
    private boolean isBackwardsCompat;

    public ObjectResult(@NonNull Context context, ObjectResultCallback<T> callback) {
        super(context);
        this.callback = callback;
    }

    @Deprecated
    public ObjectResult(@NonNull Context context, ObjectResultCallback<T> callback, @NonNull ExecutorService service) {
        super(context, service);
        this.callback = callback;
    }

    public ObjectResult(@NonNull Context context, ObjectResultCallback<T> callback, @NonNull ExecutorService service, @NonNull Handler handler) {
        super(context, service);
        this.callback = callback;
        this.handler = handler;
        this.isBackwardsCompat = true;
    }

    public T getResult() {
        if (this.getStatus() == QueryStatus.SUCCESS) {
            return this.object;
        }
        return null;
    }

    @Override
    public boolean setFailed(final FlybitsException e) {
        if (super.setFailed(e)) {
            if (this.callback != null) {
                if (this.isBackwardsCompat && this.handler != null) {
                    this.handler.post(new Runnable(){

                        @Override
                        public void run() {
                            ObjectResult.this.callback.onException(e);
                        }
                    });
                } else if (!this.isBackwardsCompat) {
                    this.callback.onException(e);
                }
            }
            return true;
        }
        return false;
    }

    public void setSuccess(final @NonNull T result) {
        if (this.setSuccess()) {
            this.object = result;
            if (this.callback != null) {
                if (this.isBackwardsCompat && this.handler != null) {
                    this.handler.post(new Runnable(){

                        @Override
                        public void run() {
                            ObjectResult.this.callback.onSuccess(result);
                        }
                    });
                } else if (!this.isBackwardsCompat) {
                    this.callback.onSuccess(result);
                }
            }
        }
    }

    public void setResult(@NonNull Result<T> result) {
        if (result.getStatus() == RequestStatus.COMPLETED) {
            this.setSuccess(result.getResult());
        } else {
            this.setFailed(result.getException());
        }
    }
}

