package com.flybits.commons.library.api;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Bundle;

import com.flybits.commons.library.BuildConfig;
import com.flybits.commons.library.exceptions.InvalidRegionException;
import com.flybits.commons.library.logging.Logger;

/**
 * This {@code FlybitsAPIConstants} class contains all Flybits Related
 */
public class FlybitsAPIConstants {

    public static String getGatewayURL(Context context) throws InvalidRegionException {
        try{

            android.content.pm.ApplicationInfo ai = context.getPackageManager().getApplicationInfo(context.getPackageName(), PackageManager.GET_META_DATA);
            Bundle bundle   = ai.metaData;
            if (bundle.containsKey("com.flybits.project.region")){

                String region   = bundle.getString("com.flybits.project.region");
                if (region == null) {
                    throw new InvalidRegionException("This version of the SDK only accepts 'south-america' or 'north-america' value as a region in your " +
                            "AndroidManifest.xml file");
                }else{
                    switch (region) {
                        case "south-america":
                            return BuildConfig.GATEWAY_SA;
                        case "north-america":
                            return BuildConfig.GATEWAY;
                        default:
                            throw new InvalidRegionException("This version of the SDK only accepts 'south-america' or 'north-america' value as a region in your " +
                                    "AndroidManifest.xml file");
                    }
                }

            }
        }catch (PackageManager.NameNotFoundException | NullPointerException ex){
            Logger.exception("FlybitsAPIConstants.getGatewayURL", ex);
        }
        return BuildConfig.GATEWAY;
    }

    public static String getMQTTURL()  {
        return BuildConfig.MQTT;
    }

    public static String constructGatewayURL(Context context, String endpoint){
        return getGatewayURL(context) + endpoint;
    }
}