package com.flybits.internal.db;

import android.arch.lifecycle.LiveData;
import android.arch.persistence.room.Dao;
import android.arch.persistence.room.Insert;
import android.arch.persistence.room.OnConflictStrategy;
import android.arch.persistence.room.Query;

import com.flybits.internal.db.models.Preference;

import java.util.List;

@Dao
public interface PreferenceDAO {

    /**
     * GET
     */
    @Query("SELECT value FROM preferences WHERE prefKey = :key")
    List<String> getIdsByKey(String key);

    @Query("SELECT * FROM preferences WHERE prefKey = :key AND value = :value")
    List<Preference> getIdsByKeyAndValue(String key, String value);

    /**
     * CREATE/INSERT
     */
    @Insert(onConflict = OnConflictStrategy.REPLACE)
    void insert(Preference entry);

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    void insert(List<Preference> entry);

    /**
     * DELETE
     */
    @Query("Delete from preferences")
    void clear();

    @Query("Delete from preferences WHERE prefKey = :key")
    void deleteByPrefKey(String key);

    @Query("Delete from preferences WHERE id = :rowID")
    void deleteByRowID(String rowID);

    @Query("Delete from preferences WHERE value = :value AND prefKey = :key")
    void deleteByKeyAndValue(String key, String value);

    /**
     * LIVEDATA
     */
    @Query("SELECT value FROM preferences WHERE prefKey = :key")
    LiveData<List<String>> getLiveValues(String key);
}
