/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import com.flybits.commons.library.models.User;
import com.flybits.commons.library.utils.Utilities;
import com.flybits.internal.db.CommonsDatabase;
import java.util.ArrayList;

public class SharedElements {
    public static final String PREF_LANGUAGE_CODES = "com.flybits.language.codes";
    public static final String PREF_JWT_TOKEN = "com.flybits.jwt.token";
    public static final String PREF_IDP_CONNECTED = "com.flybits.idp.connected";
    public static final String PREF_PROJECT_ID = "com.flybits.project.id";

    public static String getConnectedIDP(Context context) {
        SharedPreferences preferences = SharedElements.getPreferences(context);
        return preferences.getString(PREF_IDP_CONNECTED, "");
    }

    public static String getDeviceID(Context context) {
        User user = CommonsDatabase.getDatabase(context).userDao().getSingle();
        if (user != null) {
            return user.getDeviceID();
        }
        return "";
    }

    public static ArrayList<String> getEnabledLanguagesAsArray(Context context) {
        SharedPreferences preferences = SharedElements.getPreferences(context);
        String languageCodes = preferences.getString(PREF_LANGUAGE_CODES, "");
        return Utilities.convertLocalizationStringToList(languageCodes);
    }

    public static String getEnabledLanguagesAsString(Context context) {
        SharedPreferences preferences = SharedElements.getPreferences(context);
        return preferences.getString(PREF_LANGUAGE_CODES, "");
    }

    public static String getProjectID(Context context) {
        SharedPreferences preferences = SharedElements.getPreferences(context);
        return preferences.getString(PREF_PROJECT_ID, "");
    }

    public static String getSavedJWTToken(Context context) {
        SharedPreferences preferences = SharedElements.getPreferences(context);
        return preferences.getString(PREF_JWT_TOKEN, "");
    }

    public static String getUserID(Context context) {
        User user = CommonsDatabase.getDatabase(context).userDao().getSingle();
        if (user != null) {
            return user.getId();
        }
        return "";
    }

    public static void setConnectedIDP(@NonNull Context context, @NonNull String idp) {
        SharedElements.setVariable(context, PREF_IDP_CONNECTED, idp);
    }

    public static void setJWTToken(Context context, @NonNull String jwtToken) {
        SharedElements.setVariable(context, PREF_JWT_TOKEN, jwtToken);
    }

    public static void setLocalization(Context context, ArrayList<String> listOfLanguages) {
        SharedElements.setVariable(context, PREF_LANGUAGE_CODES, Utilities.convertLocalizationCodeToString(listOfLanguages));
    }

    public static void setProjectID(Context context, String projectID) {
        SharedElements.setVariable(context, PREF_PROJECT_ID, projectID);
    }

    public static SharedPreferences getPreferences(Context context) {
        return context.getSharedPreferences("FLYBITS_PREF", 0);
    }

    private static void setVariable(Context context, @NonNull String key, @NonNull String value) {
        SharedPreferences.Editor editor = SharedElements.getPreferences(context).edit();
        editor.putString(key, value);
        editor.apply();
    }
}

