/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.api;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import com.flybits.commons.library.exceptions.InvalidRegionException;
import com.flybits.commons.library.logging.Logger;

public class FlybitsAPIConstants {
    public static String getGatewayURL(Context context) throws InvalidRegionException {
        try {
            ApplicationInfo ai = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            Bundle bundle = ai.metaData;
            if (bundle.containsKey("com.flybits.project.region")) {
                String region = bundle.getString("com.flybits.project.region");
                if (region == null) {
                    throw new InvalidRegionException("This version of the SDK only accepts 'south-america' or 'north-america' value as a region in your AndroidManifest.xml file");
                }
                switch (region) {
                    case "south-america": {
                        return "https://v3-sa.flybits.com";
                    }
                    case "north-america": {
                        return "https://v3.flybits.com";
                    }
                    case "develop": {
                        return "https://dev3.flybits.com";
                    }
                    case "staging": {
                        return "https://v3-staging.flybits.com";
                    }
                }
                throw new InvalidRegionException("This version of the SDK only accepts 'south-america' or 'north-america' value as a region in your AndroidManifest.xml file");
            }
        }
        catch (PackageManager.NameNotFoundException | NullPointerException ex) {
            Logger.exception("FlybitsAPIConstants.getGatewayURL", (Exception)ex);
        }
        return "https://v3.flybits.com";
    }

    public static String getMQTTURL() {
        return "ssl://mqttv3.flybits.com:8883";
    }

    public static String constructGatewayURL(Context context, String endpoint) {
        return FlybitsAPIConstants.getGatewayURL(context) + endpoint;
    }
}

