/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.analytics.storage.sql;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.util.Log;
import com.flybits.commons.library.analytics.AnalyticsBundle;
import com.flybits.commons.library.analytics.Properties;
import com.flybits.commons.library.logging.Logger;
import org.json.JSONException;

class AnalyticsQueueStorageHelper
extends SQLiteOpenHelper {
    private static final int DATABASE_VERSION = 3;
    private static AnalyticsQueueStorageHelper mInstance;

    private AnalyticsQueueStorageHelper(Context context) {
        super(context, "flybits_analytics_db", null, 3);
    }

    public void onCreate(SQLiteDatabase db) {
        db.execSQL("CREATE TABLE AnalyticsQueue(_id INTEGER PRIMARY KEY, name TEXT, channel TEXT, timestamp BIGINT, type TEXT, userID TEXT, isFlybits INTEGER, flbProperties BLOB, properties BLOB);");
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        db.execSQL("DROP TABLE IF EXISTS AnalyticsQueue");
        this.onCreate(db);
    }

    public static synchronized AnalyticsQueueStorageHelper getInstance(Context context) {
        if (mInstance == null) {
            mInstance = new AnalyticsQueueStorageHelper(context);
        }
        return mInstance;
    }

    public void add(SQLiteDatabase db, AnalyticsBundle bundle) {
        if (bundle == null) {
            return;
        }
        ContentValues values = new ContentValues();
        values.put("name", bundle.getEventName());
        values.put("timestamp", Long.valueOf(bundle.getTimestamp()));
        values.put("type", bundle.getType().getValue());
        values.put("isFlybits", Integer.valueOf(bundle.isFlybits() ? 1 : 0));
        values.put("userID", bundle.getUserID());
        try {
            values.put("properties", bundle.getAppProperties().toJSON());
        }
        catch (JSONException e) {
            Logger.exception("AnalyticsQueueStorageHelper.add", (Exception)((Object)e));
        }
        try {
            values.put("flbProperties", bundle.getFlybitsProperties().toJSON());
        }
        catch (JSONException e) {
            Logger.exception("AnalyticsQueueStorageHelper.add", (Exception)((Object)e));
        }
        db.insertWithOnConflict("AnalyticsQueue", null, values, 5);
    }

    public AnalyticsBundle getNext(SQLiteDatabase db) {
        Cursor cursor = db.rawQuery("SELECT * FROM AnalyticsQueue ORDER BY timestamp ASC LIMIT 1", new String[0]);
        cursor.moveToFirst();
        if (cursor.getCount() == 0) {
            return null;
        }
        String name = cursor.getString(cursor.getColumnIndex("name"));
        long timestamp = cursor.getLong(cursor.getColumnIndex("timestamp"));
        String properties = cursor.getString(cursor.getColumnIndex("properties"));
        String flbProperties = cursor.getString(cursor.getColumnIndex("flbProperties"));
        boolean isFlybits = cursor.getInt(cursor.getColumnIndex("isFlybits")) == 1;
        String userID = cursor.getString(cursor.getColumnIndex("userID"));
        AnalyticsBundle.EventType type = AnalyticsBundle.EventType.fromValue(cursor.getString(cursor.getColumnIndex("type")));
        cursor.close();
        try {
            Properties flbPropertiesObj;
            if (type == AnalyticsBundle.EventType.DISCRETE_EVENT) {
                AnalyticsBundle.Builder bundle = new AnalyticsBundle.Builder(name).setAppProperties(new Properties(properties)).setUserID(userID).setCustomTimestamp(timestamp);
                if (isFlybits) {
                    bundle.setFlybitsEvent();
                }
                return bundle.build();
            }
            if ((type == AnalyticsBundle.EventType.START_TIME_EVENT || type == AnalyticsBundle.EventType.END_TIME_EVENT) && (flbPropertiesObj = new Properties(flbProperties)).getMap().containsKey("timedRef")) {
                AnalyticsBundle.Builder bundle = new AnalyticsBundle.Builder(name, type, flbPropertiesObj.getMap().get("timedRef").toString()).setAppProperties(new Properties(properties)).setUserID(userID).setCustomTimestamp(timestamp);
                if (isFlybits) {
                    bundle.setFlybitsEvent();
                }
                return bundle.build();
            }
            return null;
        }
        catch (JSONException e) {
            Logger.exception("AnalyticsQueueStorageHelper.getNext", (Exception)((Object)e));
            return null;
        }
    }

    public AnalyticsBundle[] getAll(SQLiteDatabase db) {
        Cursor cursor = db.rawQuery("SELECT * FROM AnalyticsQueue", new String[0]);
        AnalyticsBundle[] bundleList = new AnalyticsBundle[cursor.getCount()];
        int i = 0;
        if (cursor.moveToFirst()) {
            do {
                String name = cursor.getString(cursor.getColumnIndex("name"));
                long timestamp = cursor.getLong(cursor.getColumnIndex("timestamp"));
                String properties = cursor.getString(cursor.getColumnIndex("properties"));
                String flbProperties = cursor.getString(cursor.getColumnIndex("flbProperties"));
                boolean isFlybits = cursor.getInt(cursor.getColumnIndex("isFlybits")) == 1;
                String userID = cursor.getString(cursor.getColumnIndex("userID"));
                AnalyticsBundle.EventType type = AnalyticsBundle.EventType.fromValue(cursor.getString(cursor.getColumnIndex("type")));
                Log.d((String)"Testing", (String)("isFlybitsL " + isFlybits));
                try {
                    Properties flbPropertiesObj;
                    AnalyticsBundle.Builder bundle = null;
                    if (type == AnalyticsBundle.EventType.DISCRETE_EVENT) {
                        bundle = new AnalyticsBundle.Builder(name);
                    } else if ((type == AnalyticsBundle.EventType.START_TIME_EVENT || type == AnalyticsBundle.EventType.END_TIME_EVENT) && (flbPropertiesObj = new Properties(flbProperties)).getMap().containsKey("timedRef")) {
                        bundle = new AnalyticsBundle.Builder(name, type, flbPropertiesObj.getMap().get("timedRef").toString());
                    }
                    if (bundle == null) continue;
                    bundle.setAppProperties(new Properties(properties)).setCustomTimestamp(timestamp);
                    if (isFlybits) {
                        bundle.setFlybitsEvent();
                    }
                    if (userID != null) {
                        bundle.setUserID(userID);
                    }
                    bundleList[i++] = bundle.build();
                }
                catch (JSONException e) {
                    Logger.exception("AnalyticsQueueStorageHelper.getAll", (Exception)((Object)e));
                }
            } while (cursor.moveToNext());
        }
        cursor.close();
        return bundleList;
    }

    public int getSize(SQLiteDatabase db) {
        Cursor cursor = db.rawQuery("SELECT * FROM AnalyticsQueue", new String[0]);
        int size = cursor.getCount();
        cursor.close();
        return size;
    }

    public void remove(SQLiteDatabase db, int count) {
        if (count != 0) {
            db.delete("AnalyticsQueue", String.format("%1$s in (SELECT %1$s from AnalyticsQueue order by %1$s desc limit ?)", "timestamp"), new String[]{String.valueOf(count)});
        }
    }
}

