/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.internal.db;

import android.arch.persistence.db.SupportSQLiteDatabase;
import android.arch.persistence.room.Database;
import android.arch.persistence.room.Room;
import android.arch.persistence.room.RoomDatabase;
import android.arch.persistence.room.migration.Migration;
import android.content.Context;
import com.flybits.commons.library.models.User;
import com.flybits.internal.db.CachingEntryDAO;
import com.flybits.internal.db.UserDAO;
import com.flybits.internal.db.models.CachingEntry;

@Database(entities={User.class, CachingEntry.class}, version=3)
public abstract class CommonsDatabase
extends RoomDatabase {
    private static CommonsDatabase INSTANCE;
    public static final Migration MIGRATION_1_3;
    static final Migration MIGRATION_2_3;

    public abstract UserDAO userDao();

    public abstract CachingEntryDAO cachingEntryDAO();

    public static CommonsDatabase getDatabase(Context context) {
        if (INSTANCE == null) {
            INSTANCE = (CommonsDatabase)Room.databaseBuilder((Context)context, CommonsDatabase.class, (String)"commons-flybits-db").addMigrations(new Migration[]{MIGRATION_1_3, MIGRATION_2_3}).build();
        }
        return INSTANCE;
    }

    public static void destroyInstance() {
        INSTANCE = null;
    }

    static {
        MIGRATION_1_3 = new Migration(1, 3){

            public void migrate(SupportSQLiteDatabase database) {
                database.execSQL("ALTER TABLE user ADD isVerified INTEGER NOT NULL DEFAULT 0");
                database.execSQL("DROP TABLE IF EXISTS cachingentry");
                database.execSQL("CREATE TABLE cachingentry (sequence INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, cachingkey TEXT NOT NULL, contentID TEXT NOT NULL)");
                database.execSQL("CREATE UNIQUE INDEX index_cachingentry_cachingkey_contentID on cachingentry (cachingkey, contentID)");
            }
        };
        MIGRATION_2_3 = new Migration(2, 3){

            public void migrate(SupportSQLiteDatabase database) {
                database.execSQL("DROP TABLE IF EXISTS cachingentry");
                database.execSQL("CREATE TABLE cachingentry (sequence INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, cachingkey TEXT NOT NULL, contentID TEXT NOT NULL)");
                database.execSQL("CREATE UNIQUE INDEX index_cachingentry_cachingkey_contentID on cachingentry (cachingkey, contentID)");
            }
        };
    }
}

