package com.flybits.internal.db;

import android.arch.persistence.db.SupportSQLiteDatabase;
import android.arch.persistence.room.Database;
import android.arch.persistence.room.Room;
import android.arch.persistence.room.RoomDatabase;
import android.arch.persistence.room.migration.Migration;
import android.content.Context;

import com.flybits.commons.library.models.User;
import com.flybits.internal.db.models.CachingEntry;

@Database(entities = {User.class, CachingEntry.class}, version = 3)
public abstract class CommonsDatabase extends RoomDatabase {

    private static CommonsDatabase INSTANCE;

    public abstract UserDAO userDao();
    public abstract CachingEntryDAO cachingEntryDAO();

    public static CommonsDatabase getDatabase(Context context) {
        if (INSTANCE == null) {
            INSTANCE =
                    Room.databaseBuilder(context, CommonsDatabase.class, "commons-flybits-db")
                            .addMigrations(MIGRATION_1_3, MIGRATION_2_3)
                            .build();
                   /*
                    Room.inMemoryDatabaseBuilder(context.getApplicationContext(), ContextDatabase.class)
                            // To simplify the codelab, allow queries on the main thread.
                            // Don't do this on a real app! See PersistenceBasicSample for an example.
                            .allowMainThreadQueries()
                            .build();
                    */
        }
        return INSTANCE;
    }

    public static final Migration MIGRATION_1_3 = new Migration(1, 3) {
        @Override
        public void migrate(SupportSQLiteDatabase database) {
            database.execSQL("ALTER TABLE user ADD isVerified INTEGER NOT NULL DEFAULT 0");
            database.execSQL("DROP TABLE IF EXISTS cachingentry");
            database.execSQL("CREATE TABLE cachingentry (sequence INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, cachingkey TEXT NOT NULL, contentID TEXT NOT NULL)");
            database.execSQL("CREATE UNIQUE INDEX index_cachingentry_cachingkey_contentID on cachingentry (cachingkey, contentID)");
        }
    };

    static final Migration MIGRATION_2_3 = new Migration(2, 3) {
        @Override
        public void migrate(SupportSQLiteDatabase database) {
            database.execSQL("DROP TABLE IF EXISTS cachingentry");
            database.execSQL("CREATE TABLE cachingentry (sequence INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, cachingkey TEXT NOT NULL, contentID TEXT NOT NULL)");
            database.execSQL("CREATE UNIQUE INDEX index_cachingentry_cachingkey_contentID on cachingentry (cachingkey, contentID)");
        }
    };

    public static void destroyInstance() {
        INSTANCE = null;
    }
}
