/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.analytics;

import android.os.Build;
import android.support.annotation.NonNull;
import com.flybits.commons.library.analytics.Properties;
import java.util.Calendar;

public class AnalyticsBundle {
    public static final String PARAM_INTERNAL_FLB_REF = "timedRef";
    static final String PARAM_OS_TYPE = "osType";
    static final String PARAM_OS_VERSION = "osVersion";
    public static final String PARAM_USER_ID = "uid";
    private String eventName;
    private boolean isFlybits;
    private Properties appProperties;
    private Properties flbProperties;
    private EventType type;
    private String reference;
    private long timestamp;
    private String userID;

    private AnalyticsBundle(Builder builder) {
        this.eventName = builder.eventName;
        this.appProperties = builder.appProperties;
        this.isFlybits = builder.isFlybits;
        this.timestamp = builder.timestamp;
        this.type = builder.type;
        this.userID = builder.userID;
        if (this.type == EventType.START_TIME_EVENT || this.type == EventType.END_TIME_EVENT) {
            this.reference = builder.reference;
        }
        this.flbProperties = this.addFlybitsProperties(this.reference);
    }

    private Properties addFlybitsProperties(String reference) {
        Properties properties = new Properties();
        properties.addProperty(PARAM_OS_TYPE, "Android");
        properties.addProperty(PARAM_OS_VERSION, String.valueOf(Build.VERSION.SDK_INT));
        if (reference != null) {
            properties.addProperty(PARAM_INTERNAL_FLB_REF, reference);
        }
        if (this.userID != null) {
            properties.addProperty(PARAM_USER_ID, this.userID);
        }
        return properties;
    }

    public Properties getAppProperties() {
        return this.appProperties;
    }

    public String getEventName() {
        return this.eventName;
    }

    public Properties getFlybitsProperties() {
        return this.flbProperties;
    }

    public String getReference() {
        return this.reference;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public EventType getType() {
        return this.type;
    }

    public String getUserID() {
        return this.userID;
    }

    public boolean isFlybits() {
        return this.isFlybits;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof AnalyticsBundle) {
            AnalyticsBundle thatBundle = (AnalyticsBundle)o;
            if (this.getTimestamp() == thatBundle.getTimestamp() && this.getEventName().equals(thatBundle.getEventName())) {
                return true;
            }
        }
        return false;
    }

    public static enum EventType {
        UNKNOWN_EVENT("unknown_event"),
        DISCRETE_EVENT("event_discrete"),
        START_TIME_EVENT("event_timestart"),
        END_TIME_EVENT("event_timeend");

        private final String value;

        private EventType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static EventType fromValue(String value) {
            for (EventType type : EventType.values()) {
                if (!type.getValue().equalsIgnoreCase(value)) continue;
                return type;
            }
            return UNKNOWN_EVENT;
        }
    }

    public static final class Builder {
        private String eventName;
        private boolean isFlybits = false;
        private Properties appProperties = new Properties();
        private EventType type;
        private String reference = null;
        private long timestamp = Calendar.getInstance().getTimeInMillis();
        private String userID;

        private Builder() {
        }

        public Builder(String eventName) {
            this();
            this.eventName = eventName;
            this.type = EventType.DISCRETE_EVENT;
        }

        public Builder(String eventName, @NonNull EventType type, @NonNull String reference) {
            this(eventName);
            this.type = type;
            if (type == EventType.START_TIME_EVENT || type == EventType.END_TIME_EVENT) {
                this.reference = reference;
            }
        }

        public AnalyticsBundle build() {
            return new AnalyticsBundle(this);
        }

        public Builder setCustomTimestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder setFlybitsEvent() {
            this.isFlybits = true;
            return this;
        }

        public Builder setAppProperties(@NonNull Properties properties) {
            if (properties != null) {
                this.appProperties = properties;
            }
            return this;
        }

        public Builder setUserID(@NonNull String userID) {
            this.userID = userID;
            return this;
        }
    }
}

