package com.flybits.commons.library.analytics.storage.sql;

import android.provider.BaseColumns;

class AnalyticsContract {

    public static final String CREATE_TABLE =
            "CREATE TABLE " + AnalyticsEntry.TABLE_NAME + "(" +
                    AnalyticsEntry._ID + " INTEGER PRIMARY KEY, " +
                    AnalyticsEntry.COLUMN_NAME + " TEXT, " +
                    AnalyticsEntry.COLUMN_CHANNEL + " TEXT, " +
                    AnalyticsEntry.COLUMN_TIMESTAMP + " BIGINT, " +
                    AnalyticsEntry.COLUMN_TYPE + " TEXT, " +
                    AnalyticsEntry.COLUMN_USER_ID + " TEXT, " +
                    AnalyticsEntry.COLUMN_FLYBITS + " INTEGER, " +
                    AnalyticsEntry.COLUMN_FLB_PROPERTIES + " BLOB, " +
                    AnalyticsEntry.COLUMN_PROPERTIES + " BLOB);";

    public static final String[] PROJECTION = {
            AnalyticsEntry._ID,
            AnalyticsEntry.COLUMN_NAME,
            AnalyticsEntry.COLUMN_CHANNEL,
            AnalyticsEntry.COLUMN_TIMESTAMP,
            AnalyticsEntry.COLUMN_USER_ID,
            AnalyticsEntry.COLUMN_TYPE,
            AnalyticsEntry.COLUMN_FLB_PROPERTIES,
            AnalyticsEntry.COLUMN_FLYBITS,
            AnalyticsEntry.COLUMN_PROPERTIES
    };

    public static final String DELETE_TABLE =
            "DROP TABLE IF EXISTS " + AnalyticsEntry.TABLE_NAME;

    public static abstract class AnalyticsEntry implements BaseColumns {

        public static final String TABLE_NAME = "AnalyticsQueue";

        public static final String COLUMN_ID                = "id";
        public static final String COLUMN_NAME              = "name";
        public static final String COLUMN_CHANNEL           = "channel";
        public static final String COLUMN_TIMESTAMP         = "timestamp";
        public static final String COLUMN_TYPE              = "type";
        public static final String COLUMN_FLB_PROPERTIES    = "flbProperties";
        public static final String COLUMN_FLYBITS           = "isFlybits";
        public static final String COLUMN_USER_ID           = "userID";
        public static final String COLUMN_PROPERTIES        = "properties";

    }

}
