/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.models;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import com.flybits.commons.library.api.FlyAway;
import com.flybits.commons.library.api.results.BasicResult;
import com.flybits.commons.library.api.results.ObjectResult;
import com.flybits.commons.library.api.results.callbacks.BasicResultCallback;
import com.flybits.commons.library.api.results.callbacks.ObjectResultCallback;
import com.flybits.commons.library.deserializations.DeserializeUserPref;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.http.RequestStatus;
import com.flybits.commons.library.models.internal.Result;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONObject;

public abstract class UserPreferences {
    static final String API_USER_PREF = "/kernel/userpref";

    public abstract JSONObject toJSON();

    public abstract void fromJSON(String var1);

    public static ObjectResult<UserPreferences> get(final @NonNull Context context, final @NonNull Class classObject, final UserPreferences defaultsObject, ObjectResultCallback<UserPreferences> callback) {
        final Handler handler = new Handler(Looper.getMainLooper());
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        final ObjectResult<UserPreferences> request = new ObjectResult<UserPreferences>(context, callback, executorService);
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                DeserializeUserPref deserializer = defaultsObject != null ? new DeserializeUserPref(defaultsObject.getClass()) : new DeserializeUserPref(classObject);
                String methodIdentifier = "Self.get";
                try {
                    final Result<UserPreferences> getUserPrefs = FlyAway.get(context, UserPreferences.API_USER_PREF, deserializer, methodIdentifier, UserPreferences.class);
                    if (getUserPrefs.getStatus() == RequestStatus.NOT_FOUND && defaultsObject != null) {
                        String jsonBody = deserializer.toJson(defaultsObject).toString();
                        final Result<UserPreferences> createUserPrefs = FlyAway.post(context, UserPreferences.API_USER_PREF, jsonBody, deserializer, methodIdentifier, UserPreferences.class);
                        handler.post(new Runnable(){

                            @Override
                            public void run() {
                                request.setResult(createUserPrefs);
                            }
                        });
                    } else if (getUserPrefs.getStatus() == RequestStatus.NOT_FOUND) {
                        final Result<Object> result = new Result<Object>(200, "");
                        result.setResponse(null);
                        handler.post(new Runnable(){

                            @Override
                            public void run() {
                                request.setResult(result);
                            }
                        });
                    } else {
                        handler.post(new Runnable(){

                            @Override
                            public void run() {
                                request.setResult(getUserPrefs);
                            }
                        });
                    }
                }
                catch (FlybitsException e) {
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            request.setFailed(e);
                        }
                    });
                }
            }
        });
        return request;
    }

    public static ObjectResult<UserPreferences> edit(final @NonNull Context context, final @NonNull UserPreferences object, ObjectResultCallback<UserPreferences> callback) {
        final Handler handler = new Handler(Looper.getMainLooper());
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        final ObjectResult<UserPreferences> request = new ObjectResult<UserPreferences>(context, callback, executorService);
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                DeserializeUserPref deserializer = new DeserializeUserPref(object.getClass());
                String methodIdentifier = "Self.edit";
                String body = deserializer.toJson(object).toString();
                try {
                    final Result<UserPreferences> putUserPrefs = FlyAway.put(context, UserPreferences.API_USER_PREF, body, deserializer, methodIdentifier, UserPreferences.class);
                    if (putUserPrefs.getStatus() == RequestStatus.NOT_FOUND) {
                        String jsonBody = deserializer.toJson(object).toString();
                        final Result<UserPreferences> createUserPrefs = FlyAway.post(context, UserPreferences.API_USER_PREF, jsonBody, deserializer, methodIdentifier, UserPreferences.class);
                        handler.post(new Runnable(){

                            @Override
                            public void run() {
                                request.setResult(createUserPrefs);
                            }
                        });
                    } else {
                        handler.post(new Runnable(){

                            @Override
                            public void run() {
                                request.setResult(putUserPrefs);
                            }
                        });
                    }
                }
                catch (FlybitsException e) {
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            request.setFailed(e);
                        }
                    });
                }
            }
        });
        return request;
    }

    public static BasicResult clear(final @NonNull Context context, BasicResultCallback callback) {
        final Handler handler = new Handler(Looper.getMainLooper());
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        final BasicResult request = new BasicResult(context, callback, executorService);
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                String methodIdentifier = "Self.clear";
                try {
                    final Result deleteUserPref = FlyAway.delete(context, UserPreferences.API_USER_PREF, methodIdentifier, null);
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            request.setResult(deleteUserPref);
                        }
                    });
                }
                catch (FlybitsException e) {
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            request.setFailed(e);
                        }
                    });
                }
            }
        });
        return request;
    }
}

